package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AppVisibility {
  def unwrap: software.amazon.awssdk.services.appstream.model.AppVisibility
}
object AppVisibility {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AppVisibility
  ): zio.aws.appstream.model.AppVisibility = value match {
    case software.amazon.awssdk.services.appstream.model.AppVisibility.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.AppVisibility.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.appstream.model.AppVisibility.ASSOCIATED =>
      val r = ASSOCIATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AppVisibility {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppVisibility =
      software.amazon.awssdk.services.appstream.model.AppVisibility.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.appstream.model.AppVisibility {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppVisibility =
      software.amazon.awssdk.services.appstream.model.AppVisibility.ALL
  }
  case object ASSOCIATED extends zio.aws.appstream.model.AppVisibility {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AppVisibility =
      software.amazon.awssdk.services.appstream.model.AppVisibility.ASSOCIATED
  }
}
