package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopImageBuilderResponse(
    imageBuilder: Optional[zio.aws.appstream.model.ImageBuilder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse = {
    import StopImageBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse
      .builder()
      .optionallyWith(imageBuilder.map(value => value.buildAwsValue()))(
        _.imageBuilder
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly =
    zio.aws.appstream.model.StopImageBuilderResponse.wrap(buildAwsValue())
}
object StopImageBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StopImageBuilderResponse =
      zio.aws.appstream.model
        .StopImageBuilderResponse(imageBuilder.map(value => value.asEditable))
    def imageBuilder: Optional[zio.aws.appstream.model.ImageBuilder.ReadOnly]
    def getImageBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.ImageBuilder.ReadOnly] =
      AwsError.unwrapOptionField("imageBuilder", imageBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse
  ) extends zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly {
    override val imageBuilder
        : Optional[zio.aws.appstream.model.ImageBuilder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuilder())
        .map(value => zio.aws.appstream.model.ImageBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse
  ): zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly = new Wrapper(
    impl
  )
}
