package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteImageResponse(
    image: Optional[zio.aws.appstream.model.Image] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteImageResponse = {
    import DeleteImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteImageResponse
      .builder()
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteImageResponse.ReadOnly =
    zio.aws.appstream.model.DeleteImageResponse.wrap(buildAwsValue())
}
object DeleteImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteImageResponse =
      zio.aws.appstream.model
        .DeleteImageResponse(image.map(value => value.asEditable))
    def image: Optional[zio.aws.appstream.model.Image.ReadOnly]
    def getImage: ZIO[Any, AwsError, zio.aws.appstream.model.Image.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageResponse
  ) extends zio.aws.appstream.model.DeleteImageResponse.ReadOnly {
    override val image: Optional[zio.aws.appstream.model.Image.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.image())
        .map(value => zio.aws.appstream.model.Image.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageResponse
  ): zio.aws.appstream.model.DeleteImageResponse.ReadOnly = new Wrapper(impl)
}
