package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeCapacityStatus(
    desired: Integer,
    running: Optional[Integer] = Optional.Absent,
    inUse: Optional[Integer] = Optional.Absent,
    available: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus = {
    import ComputeCapacityStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
      .builder()
      .desired(desired: java.lang.Integer)
      .optionallyWith(running.map(value => value: java.lang.Integer))(_.running)
      .optionallyWith(inUse.map(value => value: java.lang.Integer))(_.inUse)
      .optionallyWith(available.map(value => value: java.lang.Integer))(
        _.available
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly =
    zio.aws.appstream.model.ComputeCapacityStatus.wrap(buildAwsValue())
}
object ComputeCapacityStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ComputeCapacityStatus =
      zio.aws.appstream.model.ComputeCapacityStatus(
        desired,
        running.map(value => value),
        inUse.map(value => value),
        available.map(value => value)
      )
    def desired: Integer
    def running: Optional[Integer]
    def inUse: Optional[Integer]
    def available: Optional[Integer]
    def getDesired: ZIO[Any, Nothing, Integer] = ZIO.succeed(desired)
    def getRunning: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("running", running)
    def getInUse: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("inUse", inUse)
    def getAvailable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("available", available)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ) extends zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly {
    override val desired: Integer = impl.desired(): Integer
    override val running: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.running())
      .map(value => value: Integer)
    override val inUse: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.inUse())
      .map(value => value: Integer)
    override val available: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.available())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus
  ): zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly = new Wrapper(impl)
}
