package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StackError(
    errorCode: Optional[zio.aws.appstream.model.StackErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StackError = {
    import StackError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StackError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StackError.ReadOnly =
    zio.aws.appstream.model.StackError.wrap(buildAwsValue())
}
object StackError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StackError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StackError =
      zio.aws.appstream.model.StackError(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Optional[zio.aws.appstream.model.StackErrorCode]
    def errorMessage: Optional[String]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.appstream.model.StackErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StackError
  ) extends zio.aws.appstream.model.StackError.ReadOnly {
    override val errorCode: Optional[zio.aws.appstream.model.StackErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.appstream.model.StackErrorCode.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StackError
  ): zio.aws.appstream.model.StackError.ReadOnly = new Wrapper(impl)
}
