package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateFleetRequest(
    fleetName: String,
    stackName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest = {
    import DisassociateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest
      .builder()
      .fleetName(fleetName: java.lang.String)
      .stackName(stackName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DisassociateFleetRequest.ReadOnly =
    zio.aws.appstream.model.DisassociateFleetRequest.wrap(buildAwsValue())
}
object DisassociateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DisassociateFleetRequest =
      zio.aws.appstream.model.DisassociateFleetRequest(fleetName, stackName)
    def fleetName: String
    def stackName: String
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getStackName: ZIO[Any, Nothing, String] = ZIO.succeed(stackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest
  ) extends zio.aws.appstream.model.DisassociateFleetRequest.ReadOnly {
    override val fleetName: String = impl.fleetName(): String
    override val stackName: String = impl.stackName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest
  ): zio.aws.appstream.model.DisassociateFleetRequest.ReadOnly = new Wrapper(
    impl
  )
}
