package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcConfig(
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.VpcConfig
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.VpcConfig.ReadOnly =
    zio.aws.appstream.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.VpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.VpcConfig =
      zio.aws.appstream.model.VpcConfig(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value)
      )
    def subnetIds: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.VpcConfig
  ) extends zio.aws.appstream.model.VpcConfig.ReadOnly {
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.VpcConfig
  ): zio.aws.appstream.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
