package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait UsageReportExecutionErrorCode {
  def unwrap: software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode
}
object UsageReportExecutionErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode
  ): zio.aws.appstream.model.UsageReportExecutionErrorCode = value match {
    case software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.RESOURCE_NOT_FOUND =>
      val r = RESOURCE_NOT_FOUND
      r
    case software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.INTERNAL_SERVICE_ERROR =>
      val r = INTERNAL_SERVICE_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.UsageReportExecutionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode =
      software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE_NOT_FOUND
      extends zio.aws.appstream.model.UsageReportExecutionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode =
      software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.RESOURCE_NOT_FOUND
  }
  case object ACCESS_DENIED
      extends zio.aws.appstream.model.UsageReportExecutionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode =
      software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.ACCESS_DENIED
  }
  case object INTERNAL_SERVICE_ERROR
      extends zio.aws.appstream.model.UsageReportExecutionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode =
      software.amazon.awssdk.services.appstream.model.UsageReportExecutionErrorCode.INTERNAL_SERVICE_ERROR
  }
}
