package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{AwsAccountId, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateImagePermissionsRequest(
    name: Name,
    sharedAccountId: AwsAccountId,
    imagePermissions: zio.aws.appstream.model.ImagePermissions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest = {
    import UpdateImagePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .sharedAccountId(AwsAccountId.unwrap(sharedAccountId): java.lang.String)
      .imagePermissions(imagePermissions.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.UpdateImagePermissionsRequest.ReadOnly =
    zio.aws.appstream.model.UpdateImagePermissionsRequest.wrap(buildAwsValue())
}
object UpdateImagePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateImagePermissionsRequest =
      zio.aws.appstream.model.UpdateImagePermissionsRequest(
        name,
        sharedAccountId,
        imagePermissions.asEditable
      )
    def name: Name
    def sharedAccountId: AwsAccountId
    def imagePermissions: zio.aws.appstream.model.ImagePermissions.ReadOnly
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getSharedAccountId: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(sharedAccountId)
    def getImagePermissions
        : ZIO[Any, Nothing, zio.aws.appstream.model.ImagePermissions.ReadOnly] =
      ZIO.succeed(imagePermissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest
  ) extends zio.aws.appstream.model.UpdateImagePermissionsRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val sharedAccountId: AwsAccountId =
      zio.aws.appstream.model.primitives.AwsAccountId(impl.sharedAccountId())
    override val imagePermissions
        : zio.aws.appstream.model.ImagePermissions.ReadOnly =
      zio.aws.appstream.model.ImagePermissions.wrap(impl.imagePermissions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest
  ): zio.aws.appstream.model.UpdateImagePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
