package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartImageBuilderResponse(
    imageBuilder: Optional[zio.aws.appstream.model.ImageBuilder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse = {
    import StartImageBuilderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse
      .builder()
      .optionallyWith(imageBuilder.map(value => value.buildAwsValue()))(
        _.imageBuilder
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly =
    zio.aws.appstream.model.StartImageBuilderResponse.wrap(buildAwsValue())
}
object StartImageBuilderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StartImageBuilderResponse =
      zio.aws.appstream.model
        .StartImageBuilderResponse(imageBuilder.map(value => value.asEditable))
    def imageBuilder: Optional[zio.aws.appstream.model.ImageBuilder.ReadOnly]
    def getImageBuilder
        : ZIO[Any, AwsError, zio.aws.appstream.model.ImageBuilder.ReadOnly] =
      AwsError.unwrapOptionField("imageBuilder", imageBuilder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse
  ) extends zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly {
    override val imageBuilder
        : Optional[zio.aws.appstream.model.ImageBuilder.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuilder())
        .map(value => zio.aws.appstream.model.ImageBuilder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse
  ): zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly = new Wrapper(
    impl
  )
}
