package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait SessionState {
  def unwrap: software.amazon.awssdk.services.appstream.model.SessionState
}
object SessionState {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.SessionState
  ): zio.aws.appstream.model.SessionState = value match {
    case software.amazon.awssdk.services.appstream.model.SessionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.SessionState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appstream.model.SessionState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.appstream.model.SessionState.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.SessionState =
      software.amazon.awssdk.services.appstream.model.SessionState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.appstream.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.SessionState =
      software.amazon.awssdk.services.appstream.model.SessionState.ACTIVE
  }
  case object PENDING extends zio.aws.appstream.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.SessionState =
      software.amazon.awssdk.services.appstream.model.SessionState.PENDING
  }
  case object EXPIRED extends zio.aws.appstream.model.SessionState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.SessionState =
      software.amazon.awssdk.services.appstream.model.SessionState.EXPIRED
  }
}
