package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait Permission {
  def unwrap: software.amazon.awssdk.services.appstream.model.Permission
}
object Permission {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.Permission
  ): zio.aws.appstream.model.Permission = value match {
    case software.amazon.awssdk.services.appstream.model.Permission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.Permission.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.appstream.model.Permission.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Permission =
      software.amazon.awssdk.services.appstream.model.Permission.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.appstream.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Permission =
      software.amazon.awssdk.services.appstream.model.Permission.ENABLED
  }
  case object DISABLED extends zio.aws.appstream.model.Permission {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.Permission =
      software.amazon.awssdk.services.appstream.model.Permission.DISABLED
  }
}
