package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAssociatedStacksRequest(
    fleetName: String,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest = {
    import ListAssociatedStacksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest
      .builder()
      .fleetName(fleetName: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ListAssociatedStacksRequest.ReadOnly =
    zio.aws.appstream.model.ListAssociatedStacksRequest.wrap(buildAwsValue())
}
object ListAssociatedStacksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ListAssociatedStacksRequest =
      zio.aws.appstream.model
        .ListAssociatedStacksRequest(fleetName, nextToken.map(value => value))
    def fleetName: String
    def nextToken: Optional[String]
    def getFleetName: ZIO[Any, Nothing, String] = ZIO.succeed(fleetName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest
  ) extends zio.aws.appstream.model.ListAssociatedStacksRequest.ReadOnly {
    override val fleetName: String = impl.fleetName(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest
  ): zio.aws.appstream.model.ListAssociatedStacksRequest.ReadOnly = new Wrapper(
    impl
  )
}
