package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LastReportGenerationExecutionError(
    errorCode: Optional[zio.aws.appstream.model.UsageReportExecutionErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError = {
    import LastReportGenerationExecutionError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly =
    zio.aws.appstream.model.LastReportGenerationExecutionError
      .wrap(buildAwsValue())
}
object LastReportGenerationExecutionError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.LastReportGenerationExecutionError =
      zio.aws.appstream.model.LastReportGenerationExecutionError(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode
        : Optional[zio.aws.appstream.model.UsageReportExecutionErrorCode]
    def errorMessage: Optional[String]
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.UsageReportExecutionErrorCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
  ) extends zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly {
    override val errorCode
        : Optional[zio.aws.appstream.model.UsageReportExecutionErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value =>
          zio.aws.appstream.model.UsageReportExecutionErrorCode.wrap(value)
        )
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.LastReportGenerationExecutionError
  ): zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly =
    new Wrapper(impl)
}
