package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait ImageBuilderState {
  def unwrap: software.amazon.awssdk.services.appstream.model.ImageBuilderState
}
object ImageBuilderState {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.ImageBuilderState
  ): zio.aws.appstream.model.ImageBuilderState = value match {
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.UPDATING_AGENT =>
      val r = UPDATING_AGENT
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.REBOOTING =>
      val r = REBOOTING
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.SNAPSHOTTING =>
      val r = SNAPSHOTTING
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.appstream.model.ImageBuilderState.PENDING_QUALIFICATION =>
      val r = PENDING_QUALIFICATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.PENDING
  }
  case object UPDATING_AGENT extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.UPDATING_AGENT
  }
  case object RUNNING extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.RUNNING
  }
  case object STOPPING extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.STOPPING
  }
  case object STOPPED extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.STOPPED
  }
  case object REBOOTING extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.REBOOTING
  }
  case object SNAPSHOTTING extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.SNAPSHOTTING
  }
  case object DELETING extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.DELETING
  }
  case object FAILED extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.FAILED
  }
  case object UPDATING extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.UPDATING
  }
  case object PENDING_QUALIFICATION
      extends zio.aws.appstream.model.ImageBuilderState {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageBuilderState =
      software.amazon.awssdk.services.appstream.model.ImageBuilderState.PENDING_QUALIFICATION
  }
}
