package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait FleetAttribute {
  def unwrap: software.amazon.awssdk.services.appstream.model.FleetAttribute
}
object FleetAttribute {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.FleetAttribute
  ): zio.aws.appstream.model.FleetAttribute = value match {
    case software.amazon.awssdk.services.appstream.model.FleetAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.FleetAttribute.VPC_CONFIGURATION =>
      val r = VPC_CONFIGURATION
      r
    case software.amazon.awssdk.services.appstream.model.FleetAttribute.VPC_CONFIGURATION_SECURITY_GROUP_IDS =>
      val r = VPC_CONFIGURATION_SECURITY_GROUP_IDS
      r
    case software.amazon.awssdk.services.appstream.model.FleetAttribute.DOMAIN_JOIN_INFO =>
      val r = DOMAIN_JOIN_INFO
      r
    case software.amazon.awssdk.services.appstream.model.FleetAttribute.IAM_ROLE_ARN =>
      val r = IAM_ROLE_ARN
      r
    case software.amazon.awssdk.services.appstream.model.FleetAttribute.USB_DEVICE_FILTER_STRINGS =>
      val r = USB_DEVICE_FILTER_STRINGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.FleetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetAttribute =
      software.amazon.awssdk.services.appstream.model.FleetAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object VPC_CONFIGURATION extends zio.aws.appstream.model.FleetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetAttribute =
      software.amazon.awssdk.services.appstream.model.FleetAttribute.VPC_CONFIGURATION
  }
  case object VPC_CONFIGURATION_SECURITY_GROUP_IDS
      extends zio.aws.appstream.model.FleetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetAttribute =
      software.amazon.awssdk.services.appstream.model.FleetAttribute.VPC_CONFIGURATION_SECURITY_GROUP_IDS
  }
  case object DOMAIN_JOIN_INFO extends zio.aws.appstream.model.FleetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetAttribute =
      software.amazon.awssdk.services.appstream.model.FleetAttribute.DOMAIN_JOIN_INFO
  }
  case object IAM_ROLE_ARN extends zio.aws.appstream.model.FleetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetAttribute =
      software.amazon.awssdk.services.appstream.model.FleetAttribute.IAM_ROLE_ARN
  }
  case object USB_DEVICE_FILTER_STRINGS
      extends zio.aws.appstream.model.FleetAttribute {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetAttribute =
      software.amazon.awssdk.services.appstream.model.FleetAttribute.USB_DEVICE_FILTER_STRINGS
  }
}
