package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUsersResponse(
    users: Optional[Iterable[zio.aws.appstream.model.User]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeUsersResponse = {
    import DescribeUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeUsersResponse
      .builder()
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeUsersResponse.ReadOnly =
    zio.aws.appstream.model.DescribeUsersResponse.wrap(buildAwsValue())
}
object DescribeUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeUsersResponse =
      zio.aws.appstream.model.DescribeUsersResponse(
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def users: Optional[List[zio.aws.appstream.model.User.ReadOnly]]
    def nextToken: Optional[String]
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.User.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUsersResponse
  ) extends zio.aws.appstream.model.DescribeUsersResponse.ReadOnly {
    override val users: Optional[List[zio.aws.appstream.model.User.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.User.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUsersResponse
  ): zio.aws.appstream.model.DescribeUsersResponse.ReadOnly = new Wrapper(impl)
}
