package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeUsageReportSubscriptionsResponse(
    usageReportSubscriptions: Optional[
      Iterable[zio.aws.appstream.model.UsageReportSubscription]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsResponse = {
    import DescribeUsageReportSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsResponse
      .builder()
      .optionallyWith(
        usageReportSubscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usageReportSubscriptions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse
      .wrap(buildAwsValue())
}
object DescribeUsageReportSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse =
      zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse(
        usageReportSubscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def usageReportSubscriptions: Optional[
      List[zio.aws.appstream.model.UsageReportSubscription.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getUsageReportSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UsageReportSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "usageReportSubscriptions",
      usageReportSubscriptions
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsResponse
  ) extends zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly {
    override val usageReportSubscriptions: Optional[
      List[zio.aws.appstream.model.UsageReportSubscription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.usageReportSubscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.UsageReportSubscription.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsResponse
  ): zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
