package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSessionsResponse(
    sessions: Optional[Iterable[zio.aws.appstream.model.Session]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse = {
    import DescribeSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse
      .builder()
      .optionallyWith(
        sessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly =
    zio.aws.appstream.model.DescribeSessionsResponse.wrap(buildAwsValue())
}
object DescribeSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeSessionsResponse =
      zio.aws.appstream.model.DescribeSessionsResponse(
        sessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sessions: Optional[List[zio.aws.appstream.model.Session.ReadOnly]]
    def nextToken: Optional[String]
    def getSessions
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.Session.ReadOnly]] =
      AwsError.unwrapOptionField("sessions", sessions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse
  ) extends zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly {
    override val sessions
        : Optional[List[zio.aws.appstream.model.Session.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.Session.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse
  ): zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
