package zio.aws.appstream.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.{DescribeImagesMaxResults, Arn}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeImagesRequest(
    names: Optional[Iterable[String]] = Optional.Absent,
    arns: Optional[Iterable[Arn]] = Optional.Absent,
    `type`: Optional[zio.aws.appstream.model.VisibilityType] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[DescribeImagesMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeImagesRequest = {
    import DescribeImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        arns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.arns)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => DescribeImagesMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeImagesRequest.ReadOnly =
    zio.aws.appstream.model.DescribeImagesRequest.wrap(buildAwsValue())
}
object DescribeImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeImagesRequest =
      zio.aws.appstream.model.DescribeImagesRequest(
        names.map(value => value),
        arns.map(value => value),
        `type`.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def names: Optional[List[String]]
    def arns: Optional[List[Arn]]
    def `type`: Optional[zio.aws.appstream.model.VisibilityType]
    def nextToken: Optional[String]
    def maxResults: Optional[DescribeImagesMaxResults]
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("arns", arns)
    def getType: ZIO[Any, AwsError, zio.aws.appstream.model.VisibilityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeImagesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
  ) extends zio.aws.appstream.model.DescribeImagesRequest.ReadOnly {
    override val names: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val arns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.arns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.Arn(item)
        }.toList
      )
    override val `type`: Optional[zio.aws.appstream.model.VisibilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.appstream.model.VisibilityType.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[DescribeImagesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.appstream.model.primitives.DescribeImagesMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeImagesRequest
  ): zio.aws.appstream.model.DescribeImagesRequest.ReadOnly = new Wrapper(impl)
}
