package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteImageRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteImageRequest = {
    import DeleteImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteImageRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteImageRequest.ReadOnly =
    zio.aws.appstream.model.DeleteImageRequest.wrap(buildAwsValue())
}
object DeleteImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteImageRequest =
      zio.aws.appstream.model.DeleteImageRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageRequest
  ) extends zio.aws.appstream.model.DeleteImageRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteImageRequest
  ): zio.aws.appstream.model.DeleteImageRequest.ReadOnly = new Wrapper(impl)
}
