package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEntitlementRequest(name: Name, stackName: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest = {
    import DeleteEntitlementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .stackName(Name.unwrap(stackName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteEntitlementRequest.ReadOnly =
    zio.aws.appstream.model.DeleteEntitlementRequest.wrap(buildAwsValue())
}
object DeleteEntitlementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteEntitlementRequest =
      zio.aws.appstream.model.DeleteEntitlementRequest(name, stackName)
    def name: Name
    def stackName: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStackName: ZIO[Any, Nothing, Name] = ZIO.succeed(stackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest
  ) extends zio.aws.appstream.model.DeleteEntitlementRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
    override val stackName: Name =
      zio.aws.appstream.model.primitives.Name(impl.stackName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest
  ): zio.aws.appstream.model.DeleteEntitlementRequest.ReadOnly = new Wrapper(
    impl
  )
}
