package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.DirectoryName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDirectoryConfigRequest(directoryName: DirectoryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest = {
    import DeleteDirectoryConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest
      .builder()
      .directoryName(DirectoryName.unwrap(directoryName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.DeleteDirectoryConfigRequest.ReadOnly =
    zio.aws.appstream.model.DeleteDirectoryConfigRequest.wrap(buildAwsValue())
}
object DeleteDirectoryConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteDirectoryConfigRequest =
      zio.aws.appstream.model.DeleteDirectoryConfigRequest(directoryName)
    def directoryName: DirectoryName
    def getDirectoryName: ZIO[Any, Nothing, DirectoryName] =
      ZIO.succeed(directoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest
  ) extends zio.aws.appstream.model.DeleteDirectoryConfigRequest.ReadOnly {
    override val directoryName: DirectoryName =
      zio.aws.appstream.model.primitives.DirectoryName(impl.directoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest
  ): zio.aws.appstream.model.DeleteDirectoryConfigRequest.ReadOnly =
    new Wrapper(impl)
}
