package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApplicationRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.appstream.model.DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DeleteApplicationRequest =
      zio.aws.appstream.model.DeleteApplicationRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest
  ) extends zio.aws.appstream.model.DeleteApplicationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appstream.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest
  ): zio.aws.appstream.model.DeleteApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
