package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.SettingsGroup
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationSettingsResponse(
    enabled: Optional[Boolean] = Optional.Absent,
    settingsGroup: Optional[SettingsGroup] = Optional.Absent,
    s3BucketName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse = {
    import ApplicationSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        settingsGroup.map(value =>
          SettingsGroup.unwrap(value): java.lang.String
        )
      )(_.settingsGroup)
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly =
    zio.aws.appstream.model.ApplicationSettingsResponse.wrap(buildAwsValue())
}
object ApplicationSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ApplicationSettingsResponse =
      zio.aws.appstream.model.ApplicationSettingsResponse(
        enabled.map(value => value),
        settingsGroup.map(value => value),
        s3BucketName.map(value => value)
      )
    def enabled: Optional[Boolean]
    def settingsGroup: Optional[SettingsGroup]
    def s3BucketName: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getSettingsGroup: ZIO[Any, AwsError, SettingsGroup] =
      AwsError.unwrapOptionField("settingsGroup", settingsGroup)
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse
  ) extends zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val settingsGroup: Optional[SettingsGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.settingsGroup())
      .map(value => zio.aws.appstream.model.primitives.SettingsGroup(value))
    override val s3BucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse
  ): zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
