package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait AccessEndpointType {
  def unwrap: software.amazon.awssdk.services.appstream.model.AccessEndpointType
}
object AccessEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.AccessEndpointType
  ): zio.aws.appstream.model.AccessEndpointType = value match {
    case software.amazon.awssdk.services.appstream.model.AccessEndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.AccessEndpointType.STREAMING =>
      val r = STREAMING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.AccessEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AccessEndpointType =
      software.amazon.awssdk.services.appstream.model.AccessEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object STREAMING extends zio.aws.appstream.model.AccessEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.AccessEndpointType =
      software.amazon.awssdk.services.appstream.model.AccessEndpointType.STREAMING
  }
}
