package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFleetResponse(
    fleet: Optional[zio.aws.appstream.model.Fleet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateFleetResponse = {
    import UpdateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateFleetResponse
      .builder()
      .optionallyWith(fleet.map(value => value.buildAwsValue()))(_.fleet)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateFleetResponse.ReadOnly =
    zio.aws.appstream.model.UpdateFleetResponse.wrap(buildAwsValue())
}
object UpdateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateFleetResponse =
      zio.aws.appstream.model
        .UpdateFleetResponse(fleet.map(value => value.asEditable))
    def fleet: Optional[zio.aws.appstream.model.Fleet.ReadOnly]
    def getFleet: ZIO[Any, AwsError, zio.aws.appstream.model.Fleet.ReadOnly] =
      AwsError.unwrapOptionField("fleet", fleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateFleetResponse
  ) extends zio.aws.appstream.model.UpdateFleetResponse.ReadOnly {
    override val fleet: Optional[zio.aws.appstream.model.Fleet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleet())
        .map(value => zio.aws.appstream.model.Fleet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateFleetResponse
  ): zio.aws.appstream.model.UpdateFleetResponse.ReadOnly = new Wrapper(impl)
}
