package zio.aws.appstream.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appstream.model.primitives.Timestamp
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UsageReportSubscription(
    s3BucketName: Optional[String] = Optional.Absent,
    schedule: Optional[zio.aws.appstream.model.UsageReportSchedule] =
      Optional.Absent,
    lastGeneratedReportDate: Optional[Timestamp] = Optional.Absent,
    subscriptionErrors: Optional[
      Iterable[zio.aws.appstream.model.LastReportGenerationExecutionError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UsageReportSubscription = {
    import UsageReportSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UsageReportSubscription
      .builder()
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .optionallyWith(schedule.map(value => value.unwrap))(_.schedule)
      .optionallyWith(
        lastGeneratedReportDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastGeneratedReportDate)
      .optionallyWith(
        subscriptionErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptionErrors)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UsageReportSubscription.ReadOnly =
    zio.aws.appstream.model.UsageReportSubscription.wrap(buildAwsValue())
}
object UsageReportSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UsageReportSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UsageReportSubscription =
      zio.aws.appstream.model.UsageReportSubscription(
        s3BucketName.map(value => value),
        schedule.map(value => value),
        lastGeneratedReportDate.map(value => value),
        subscriptionErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def s3BucketName: Optional[String]
    def schedule: Optional[zio.aws.appstream.model.UsageReportSchedule]
    def lastGeneratedReportDate: Optional[Timestamp]
    def subscriptionErrors: Optional[
      List[zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly]
    ]
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.appstream.model.UsageReportSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getLastGeneratedReportDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastGeneratedReportDate", lastGeneratedReportDate)
    def getSubscriptionErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly
    ]] = AwsError.unwrapOptionField("subscriptionErrors", subscriptionErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UsageReportSubscription
  ) extends zio.aws.appstream.model.UsageReportSubscription.ReadOnly {
    override val s3BucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => value: String)
    override val schedule
        : Optional[zio.aws.appstream.model.UsageReportSchedule] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.appstream.model.UsageReportSchedule.wrap(value))
    override val lastGeneratedReportDate: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastGeneratedReportDate())
        .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val subscriptionErrors: Optional[
      List[zio.aws.appstream.model.LastReportGenerationExecutionError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.LastReportGenerationExecutionError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UsageReportSubscription
  ): zio.aws.appstream.model.UsageReportSubscription.ReadOnly = new Wrapper(
    impl
  )
}
