package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait ImageStateChangeReasonCode {
  def unwrap: software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode
}
object ImageStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode
  ): zio.aws.appstream.model.ImageStateChangeReasonCode = value match {
    case software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.IMAGE_BUILDER_NOT_AVAILABLE =>
      val r = IMAGE_BUILDER_NOT_AVAILABLE
      r
    case software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.IMAGE_COPY_FAILURE =>
      val r = IMAGE_COPY_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.ImageStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_ERROR
      extends zio.aws.appstream.model.ImageStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.INTERNAL_ERROR
  }
  case object IMAGE_BUILDER_NOT_AVAILABLE
      extends zio.aws.appstream.model.ImageStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.IMAGE_BUILDER_NOT_AVAILABLE
  }
  case object IMAGE_COPY_FAILURE
      extends zio.aws.appstream.model.ImageStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode =
      software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode.IMAGE_COPY_FAILURE
  }
}
