package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateApplicationResponse(
    application: Option[zio.aws.appstream.model.Application] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateApplicationResponse
      .builder()
      .optionallyWith(application.map(value => value.buildAwsValue()))(
        _.application
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.appstream.model.UpdateApplicationResponse.wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateApplicationResponse =
      zio.aws.appstream.model
        .UpdateApplicationResponse(application.map(value => value.asEditable))
    def application: Option[zio.aws.appstream.model.Application.ReadOnly]
    def getApplication
        : ZIO[Any, AwsError, zio.aws.appstream.model.Application.ReadOnly] =
      AwsError.unwrapOptionField("application", application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateApplicationResponse
  ) extends zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly {
    override val application
        : Option[zio.aws.appstream.model.Application.ReadOnly] = scala
      .Option(impl.application())
      .map(value => zio.aws.appstream.model.Application.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateApplicationResponse
  ): zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
