package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScriptDetails(
    scriptS3Location: zio.aws.appstream.model.S3Location,
    executablePath: String,
    executableParameters: Option[String] = None,
    timeoutInSeconds: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ScriptDetails = {
    import ScriptDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ScriptDetails
      .builder()
      .scriptS3Location(scriptS3Location.buildAwsValue())
      .executablePath(executablePath: java.lang.String)
      .optionallyWith(
        executableParameters.map(value => value: java.lang.String)
      )(_.executableParameters)
      .timeoutInSeconds(timeoutInSeconds: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ScriptDetails.ReadOnly =
    zio.aws.appstream.model.ScriptDetails.wrap(buildAwsValue())
}
object ScriptDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ScriptDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ScriptDetails =
      zio.aws.appstream.model.ScriptDetails(
        scriptS3Location.asEditable,
        executablePath,
        executableParameters.map(value => value),
        timeoutInSeconds
      )
    def scriptS3Location: zio.aws.appstream.model.S3Location.ReadOnly
    def executablePath: String
    def executableParameters: Option[String]
    def timeoutInSeconds: Integer
    def getScriptS3Location
        : ZIO[Any, Nothing, zio.aws.appstream.model.S3Location.ReadOnly] =
      ZIO.succeed(scriptS3Location)
    def getExecutablePath: ZIO[Any, Nothing, String] =
      ZIO.succeed(executablePath)
    def getExecutableParameters: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executableParameters", executableParameters)
    def getTimeoutInSeconds: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(timeoutInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ScriptDetails
  ) extends zio.aws.appstream.model.ScriptDetails.ReadOnly {
    override val scriptS3Location: zio.aws.appstream.model.S3Location.ReadOnly =
      zio.aws.appstream.model.S3Location.wrap(impl.scriptS3Location())
    override val executablePath: String = impl.executablePath(): String
    override val executableParameters: Option[String] =
      scala.Option(impl.executableParameters()).map(value => value: String)
    override val timeoutInSeconds: Integer = impl.timeoutInSeconds(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ScriptDetails
  ): zio.aws.appstream.model.ScriptDetails.ReadOnly = new Wrapper(impl)
}
