package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  BooleanObject,
  Timestamp,
  Arn,
  Integer,
  UsbDeviceFilterString
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Fleet(
    arn: Arn,
    name: String,
    displayName: Option[String] = None,
    description: Option[String] = None,
    imageName: Option[String] = None,
    imageArn: Option[Arn] = None,
    instanceType: String,
    fleetType: Option[zio.aws.appstream.model.FleetType] = None,
    computeCapacityStatus: zio.aws.appstream.model.ComputeCapacityStatus,
    maxUserDurationInSeconds: Option[Integer] = None,
    disconnectTimeoutInSeconds: Option[Integer] = None,
    state: zio.aws.appstream.model.FleetState,
    vpcConfig: Option[zio.aws.appstream.model.VpcConfig] = None,
    createdTime: Option[Timestamp] = None,
    fleetErrors: Option[Iterable[zio.aws.appstream.model.FleetError]] = None,
    enableDefaultInternetAccess: Option[BooleanObject] = None,
    domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo] = None,
    idleDisconnectTimeoutInSeconds: Option[Integer] = None,
    iamRoleArn: Option[Arn] = None,
    streamView: Option[zio.aws.appstream.model.StreamView] = None,
    platform: Option[zio.aws.appstream.model.PlatformType] = None,
    maxConcurrentSessions: Option[Integer] = None,
    usbDeviceFilterStrings: Option[Iterable[UsbDeviceFilterString]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.appstream.model.Fleet = {
    import Fleet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Fleet
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(imageName.map(value => value: java.lang.String))(
        _.imageName
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .instanceType(instanceType: java.lang.String)
      .optionallyWith(fleetType.map(value => value.unwrap))(_.fleetType)
      .computeCapacityStatus(computeCapacityStatus.buildAwsValue())
      .optionallyWith(
        maxUserDurationInSeconds.map(value => value: java.lang.Integer)
      )(_.maxUserDurationInSeconds)
      .optionallyWith(
        disconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.disconnectTimeoutInSeconds)
      .state(state.unwrap)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        fleetErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetErrors)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        idleDisconnectTimeoutInSeconds.map(value => value: java.lang.Integer)
      )(_.idleDisconnectTimeoutInSeconds)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(streamView.map(value => value.unwrap))(_.streamView)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        maxConcurrentSessions.map(value => value: java.lang.Integer)
      )(_.maxConcurrentSessions)
      .optionallyWith(
        usbDeviceFilterStrings.map(value =>
          value.map { item =>
            UsbDeviceFilterString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.usbDeviceFilterStrings)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Fleet.ReadOnly =
    zio.aws.appstream.model.Fleet.wrap(buildAwsValue())
}
object Fleet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.Fleet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Fleet =
      zio.aws.appstream.model.Fleet(
        arn,
        name,
        displayName.map(value => value),
        description.map(value => value),
        imageName.map(value => value),
        imageArn.map(value => value),
        instanceType,
        fleetType.map(value => value),
        computeCapacityStatus.asEditable,
        maxUserDurationInSeconds.map(value => value),
        disconnectTimeoutInSeconds.map(value => value),
        state,
        vpcConfig.map(value => value.asEditable),
        createdTime.map(value => value),
        fleetErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        idleDisconnectTimeoutInSeconds.map(value => value),
        iamRoleArn.map(value => value),
        streamView.map(value => value),
        platform.map(value => value),
        maxConcurrentSessions.map(value => value),
        usbDeviceFilterStrings.map(value => value)
      )
    def arn: Arn
    def name: String
    def displayName: Option[String]
    def description: Option[String]
    def imageName: Option[String]
    def imageArn: Option[Arn]
    def instanceType: String
    def fleetType: Option[zio.aws.appstream.model.FleetType]
    def computeCapacityStatus
        : zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly
    def maxUserDurationInSeconds: Option[Integer]
    def disconnectTimeoutInSeconds: Option[Integer]
    def state: zio.aws.appstream.model.FleetState
    def vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def createdTime: Option[Timestamp]
    def fleetErrors: Option[List[zio.aws.appstream.model.FleetError.ReadOnly]]
    def enableDefaultInternetAccess: Option[BooleanObject]
    def domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def idleDisconnectTimeoutInSeconds: Option[Integer]
    def iamRoleArn: Option[Arn]
    def streamView: Option[zio.aws.appstream.model.StreamView]
    def platform: Option[zio.aws.appstream.model.PlatformType]
    def maxConcurrentSessions: Option[Integer]
    def usbDeviceFilterStrings: Option[List[UsbDeviceFilterString]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageName", imageName)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getFleetType: ZIO[Any, AwsError, zio.aws.appstream.model.FleetType] =
      AwsError.unwrapOptionField("fleetType", fleetType)
    def getComputeCapacityStatus: ZIO[
      Any,
      Nothing,
      zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly
    ] = ZIO.succeed(computeCapacityStatus)
    def getMaxUserDurationInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxUserDurationInSeconds", maxUserDurationInSeconds)
    def getDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInSeconds",
        disconnectTimeoutInSeconds
      )
    def getState: ZIO[Any, Nothing, zio.aws.appstream.model.FleetState] =
      ZIO.succeed(state)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getFleetErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.FleetError.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetErrors", fleetErrors)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getIdleDisconnectTimeoutInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInSeconds",
        idleDisconnectTimeoutInSeconds
      )
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getStreamView: ZIO[Any, AwsError, zio.aws.appstream.model.StreamView] =
      AwsError.unwrapOptionField("streamView", streamView)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getMaxConcurrentSessions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConcurrentSessions", maxConcurrentSessions)
    def getUsbDeviceFilterStrings
        : ZIO[Any, AwsError, List[UsbDeviceFilterString]] = AwsError
      .unwrapOptionField("usbDeviceFilterStrings", usbDeviceFilterStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Fleet
  ) extends zio.aws.appstream.model.Fleet.ReadOnly {
    override val arn: Arn = zio.aws.appstream.model.primitives.Arn(impl.arn())
    override val name: String = impl.name(): String
    override val displayName: Option[String] =
      scala.Option(impl.displayName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val imageName: Option[String] =
      scala.Option(impl.imageName()).map(value => value: String)
    override val imageArn: Option[Arn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val instanceType: String = impl.instanceType(): String
    override val fleetType: Option[zio.aws.appstream.model.FleetType] = scala
      .Option(impl.fleetType())
      .map(value => zio.aws.appstream.model.FleetType.wrap(value))
    override val computeCapacityStatus
        : zio.aws.appstream.model.ComputeCapacityStatus.ReadOnly =
      zio.aws.appstream.model.ComputeCapacityStatus
        .wrap(impl.computeCapacityStatus())
    override val maxUserDurationInSeconds: Option[Integer] =
      scala.Option(impl.maxUserDurationInSeconds()).map(value => value: Integer)
    override val disconnectTimeoutInSeconds: Option[Integer] = scala
      .Option(impl.disconnectTimeoutInSeconds())
      .map(value => value: Integer)
    override val state: zio.aws.appstream.model.FleetState =
      zio.aws.appstream.model.FleetState.wrap(impl.state())
    override val vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val fleetErrors
        : Option[List[zio.aws.appstream.model.FleetError.ReadOnly]] = scala
      .Option(impl.fleetErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.FleetError.wrap(item)
        }.toList
      )
    override val enableDefaultInternetAccess: Option[BooleanObject] = scala
      .Option(impl.enableDefaultInternetAccess())
      .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] = scala
      .Option(impl.domainJoinInfo())
      .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val idleDisconnectTimeoutInSeconds: Option[Integer] = scala
      .Option(impl.idleDisconnectTimeoutInSeconds())
      .map(value => value: Integer)
    override val iamRoleArn: Option[Arn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val streamView: Option[zio.aws.appstream.model.StreamView] = scala
      .Option(impl.streamView())
      .map(value => zio.aws.appstream.model.StreamView.wrap(value))
    override val platform: Option[zio.aws.appstream.model.PlatformType] = scala
      .Option(impl.platform())
      .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val maxConcurrentSessions: Option[Integer] =
      scala.Option(impl.maxConcurrentSessions()).map(value => value: Integer)
    override val usbDeviceFilterStrings: Option[List[UsbDeviceFilterString]] =
      scala
        .Option(impl.usbDeviceFilterStrings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.primitives.UsbDeviceFilterString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Fleet
  ): zio.aws.appstream.model.Fleet.ReadOnly = new Wrapper(impl)
}
