package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStacksResponse(
    stacks: Option[Iterable[zio.aws.appstream.model.Stack]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeStacksResponse = {
    import DescribeStacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeStacksResponse
      .builder()
      .optionallyWith(
        stacks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stacks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeStacksResponse.ReadOnly =
    zio.aws.appstream.model.DescribeStacksResponse.wrap(buildAwsValue())
}
object DescribeStacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeStacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeStacksResponse =
      zio.aws.appstream.model.DescribeStacksResponse(
        stacks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stacks: Option[List[zio.aws.appstream.model.Stack.ReadOnly]]
    def nextToken: Option[String]
    def getStacks
        : ZIO[Any, AwsError, List[zio.aws.appstream.model.Stack.ReadOnly]] =
      AwsError.unwrapOptionField("stacks", stacks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeStacksResponse
  ) extends zio.aws.appstream.model.DescribeStacksResponse.ReadOnly {
    override val stacks: Option[List[zio.aws.appstream.model.Stack.ReadOnly]] =
      scala
        .Option(impl.stacks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.Stack.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeStacksResponse
  ): zio.aws.appstream.model.DescribeStacksResponse.ReadOnly = new Wrapper(impl)
}
