package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFleetsRequest(
    names: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest = {
    import DescribeFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.DescribeFleetsRequest.ReadOnly =
    zio.aws.appstream.model.DescribeFleetsRequest.wrap(buildAwsValue())
}
object DescribeFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.DescribeFleetsRequest =
      zio.aws.appstream.model.DescribeFleetsRequest(
        names.map(value => value),
        nextToken.map(value => value)
      )
    def names: Option[List[String]]
    def nextToken: Option[String]
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
  ) extends zio.aws.appstream.model.DescribeFleetsRequest.ReadOnly {
    override val names: Option[List[String]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest
  ): zio.aws.appstream.model.DescribeFleetsRequest.ReadOnly = new Wrapper(impl)
}
