package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateApplicationFleetResponse(
    applicationFleetAssociation: Option[
      zio.aws.appstream.model.ApplicationFleetAssociation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetResponse = {
    import AssociateApplicationFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetResponse
      .builder()
      .optionallyWith(
        applicationFleetAssociation.map(value => value.buildAwsValue())
      )(_.applicationFleetAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly =
    zio.aws.appstream.model.AssociateApplicationFleetResponse
      .wrap(buildAwsValue())
}
object AssociateApplicationFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.AssociateApplicationFleetResponse =
      zio.aws.appstream.model.AssociateApplicationFleetResponse(
        applicationFleetAssociation.map(value => value.asEditable)
      )
    def applicationFleetAssociation
        : Option[zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly]
    def getApplicationFleetAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationFleetAssociation",
      applicationFleetAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetResponse
  ) extends zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly {
    override val applicationFleetAssociation
        : Option[zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly] =
      scala
        .Option(impl.applicationFleetAssociation())
        .map(value =>
          zio.aws.appstream.model.ApplicationFleetAssociation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetResponse
  ): zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly =
    new Wrapper(impl)
}
