package zio.aws.appstream
import zio.aws.appstream.model.UpdateStackResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.appstream.{
  AppStreamAsyncClientBuilder,
  AppStreamAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.appstream.model.{
  DeleteUserRequest,
  UpdateEntitlementRequest,
  UpdateApplicationRequest,
  DescribeUsersRequest,
  DeleteImagePermissionsRequest,
  CopyImageRequest,
  DescribeStacksRequest,
  CreateImageBuilderRequest,
  DeleteApplicationRequest,
  DescribeUsageReportSubscriptionsRequest,
  EnableUserRequest,
  AssociateFleetRequest,
  UpdateImagePermissionsRequest,
  DescribeFleetsRequest,
  DescribeDirectoryConfigsRequest,
  ExpireSessionRequest,
  DeleteEntitlementRequest,
  DescribeImagePermissionsRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DeleteImageRequest,
  AssociateApplicationFleetRequest,
  CreateEntitlementRequest,
  CreateImageBuilderStreamingUrlRequest,
  DeleteStackRequest,
  DescribeSessionsRequest,
  DescribeApplicationsRequest,
  DescribeUserStackAssociationsRequest,
  UpdateDirectoryConfigRequest,
  StartImageBuilderRequest,
  DisassociateApplicationFromEntitlementRequest,
  DeleteImageBuilderRequest,
  CreateUsageReportSubscriptionRequest,
  DescribeApplicationFleetAssociationsRequest,
  CreateUserRequest,
  AssociateApplicationToEntitlementRequest,
  UpdateFleetRequest,
  CreateFleetRequest,
  CreateStreamingUrlRequest,
  ListEntitledApplicationsRequest,
  DeleteAppBlockRequest,
  CreateAppBlockRequest,
  CreateUpdatedImageRequest,
  UntagResourceRequest,
  DisassociateFleetRequest,
  DescribeImageBuildersRequest,
  DescribeImagesRequest,
  StartFleetRequest,
  StopImageBuilderRequest,
  ListAssociatedStacksRequest,
  CreateDirectoryConfigRequest,
  BatchAssociateUserStackRequest,
  BatchDisassociateUserStackRequest,
  StopFleetRequest,
  ListAssociatedFleetsRequest,
  DescribeEntitlementsRequest,
  DisableUserRequest,
  DescribeAppBlocksRequest,
  UpdateStackRequest,
  CreateStackRequest,
  TagResourceRequest,
  DeleteFleetRequest,
  DeleteDirectoryConfigRequest,
  DisassociateApplicationFleetRequest,
  DeleteUsageReportSubscriptionRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.appstream.model.{
  DeleteEntitlementResponse,
  DescribeEntitlementsResponse,
  CopyImageResponse,
  DescribeApplicationFleetAssociationsResponse,
  Entitlement,
  SharedImagePermissions,
  BatchDisassociateUserStackResponse,
  CreateFleetResponse,
  Image,
  CreateUsageReportSubscriptionResponse,
  DeleteFleetResponse,
  UsageReportSubscription,
  CreateUpdatedImageResponse,
  DescribeImagePermissionsResponse,
  UpdateStackResponse,
  DescribeImagesResponse,
  StartImageBuilderResponse,
  CreateImageBuilderStreamingUrlResponse,
  User,
  Fleet,
  ListAssociatedFleetsResponse,
  StopFleetResponse,
  DeleteUsageReportSubscriptionResponse,
  UpdateApplicationResponse,
  Application,
  ExpireSessionResponse,
  BatchAssociateUserStackResponse,
  DescribeImageBuildersResponse,
  DescribeUserStackAssociationsResponse,
  DeleteImageBuilderResponse,
  EnableUserResponse,
  ListTagsForResourceResponse,
  DescribeAppBlocksResponse,
  AssociateApplicationToEntitlementResponse,
  DeleteStackResponse,
  DescribeFleetsResponse,
  UntagResourceResponse,
  AssociateFleetResponse,
  ApplicationFleetAssociation,
  CreateEntitlementResponse,
  DisassociateFleetResponse,
  DescribeUsageReportSubscriptionsResponse,
  ImageBuilder,
  CreateAppBlockResponse,
  CreateUserResponse,
  CreateStackResponse,
  Session,
  DescribeUsersResponse,
  StopImageBuilderResponse,
  EntitledApplication,
  DescribeSessionsResponse,
  CreateApplicationResponse,
  Stack,
  StartFleetResponse,
  CreateDirectoryConfigResponse,
  DeleteDirectoryConfigResponse,
  DeleteUserResponse,
  AssociateApplicationFleetResponse,
  AppBlock,
  CreateStreamingUrlResponse,
  DescribeApplicationsResponse,
  ListAssociatedStacksResponse,
  DisassociateApplicationFleetResponse,
  DeleteImageResponse,
  UpdateImagePermissionsResponse,
  UserStackAssociation,
  DisableUserResponse,
  DeleteImagePermissionsResponse,
  DescribeStacksResponse,
  DeleteAppBlockResponse,
  UpdateDirectoryConfigResponse,
  TagResourceResponse,
  DisassociateApplicationFromEntitlementResponse,
  DescribeDirectoryConfigsResponse,
  UpdateEntitlementResponse,
  ListEntitledApplicationsResponse,
  DirectoryConfig,
  CreateImageBuilderResponse,
  UpdateFleetResponse,
  DeleteApplicationResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait AppStream extends AspectSupport[AppStream] {
  val api: AppStreamAsyncClient
  def describeEntitlements(
      request: DescribeEntitlementsRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.Entitlement.ReadOnly]
  def describeEntitlementsPaginated(
      request: DescribeEntitlementsRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly]
  def stopImageBuilder(
      request: StopImageBuilderRequest
  ): IO[AwsError, zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly]
  def batchAssociateUserStack(request: BatchAssociateUserStackRequest): IO[
    AwsError,
    zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly
  ]
  def describeStacks(
      request: DescribeStacksRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.Stack.ReadOnly]
  def describeStacksPaginated(
      request: DescribeStacksRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeStacksResponse.ReadOnly]
  def deleteApplication(
      request: DeleteApplicationRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteApplicationResponse.ReadOnly]
  def describeSessions(
      request: DescribeSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.Session.ReadOnly]
  def describeSessionsPaginated(
      request: DescribeSessionsRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly]
  def deleteDirectoryConfig(request: DeleteDirectoryConfigRequest): IO[
    AwsError,
    zio.aws.appstream.model.DeleteDirectoryConfigResponse.ReadOnly
  ]
  def disassociateApplicationFleet(
      request: DisassociateApplicationFleetRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DisassociateApplicationFleetResponse.ReadOnly
  ]
  def describeImagePermissions(
      request: DescribeImagePermissionsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly,
    zio.aws.appstream.model.SharedImagePermissions.ReadOnly
  ]]
  def describeImagePermissionsPaginated(
      request: DescribeImagePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly
  ]
  def createEntitlement(
      request: CreateEntitlementRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly]
  def deleteUsageReportSubscription(
      request: DeleteUsageReportSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DeleteUsageReportSubscriptionResponse.ReadOnly
  ]
  def startFleet(
      request: StartFleetRequest
  ): IO[AwsError, zio.aws.appstream.model.StartFleetResponse.ReadOnly]
  def createUsageReportSubscription(
      request: CreateUsageReportSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly
  ]
  def deleteEntitlement(
      request: DeleteEntitlementRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteEntitlementResponse.ReadOnly]
  def describeFleets(
      request: DescribeFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.Fleet.ReadOnly]
  def describeFleetsPaginated(
      request: DescribeFleetsRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly]
  def describeUsageReportSubscriptions(
      request: DescribeUsageReportSubscriptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.appstream.model.UsageReportSubscription.ReadOnly
  ]
  def describeUsageReportSubscriptionsPaginated(
      request: DescribeUsageReportSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly
  ]
  def deleteImage(
      request: DeleteImageRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteImageResponse.ReadOnly]
  def deleteImageBuilder(
      request: DeleteImageBuilderRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly]
  def describeImageBuilders(
      request: DescribeImageBuildersRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.ImageBuilder.ReadOnly]
  def describeImageBuildersPaginated(request: DescribeImageBuildersRequest): IO[
    AwsError,
    zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly
  ]
  def associateFleet(
      request: AssociateFleetRequest
  ): IO[AwsError, zio.aws.appstream.model.AssociateFleetResponse.ReadOnly]
  def createApplication(
      request: CreateApplicationRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateApplicationResponse.ReadOnly]
  def createUpdatedImage(
      request: CreateUpdatedImageRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly]
  def deleteAppBlock(
      request: DeleteAppBlockRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteAppBlockResponse.ReadOnly]
  def associateApplicationToEntitlement(
      request: AssociateApplicationToEntitlementRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.AssociateApplicationToEntitlementResponse.ReadOnly
  ]
  def describeAppBlocks(
      request: DescribeAppBlocksRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.AppBlock.ReadOnly]
  def describeAppBlocksPaginated(
      request: DescribeAppBlocksRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly]
  def deleteFleet(
      request: DeleteFleetRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteFleetResponse.ReadOnly]
  def associateApplicationFleet(request: AssociateApplicationFleetRequest): IO[
    AwsError,
    zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly
  ]
  def createImageBuilder(
      request: CreateImageBuilderRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly]
  def createUser(
      request: CreateUserRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateUserResponse.ReadOnly]
  def updateFleet(
      request: UpdateFleetRequest
  ): IO[AwsError, zio.aws.appstream.model.UpdateFleetResponse.ReadOnly]
  def describeImages(
      request: DescribeImagesRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.Image.ReadOnly]
  def describeImagesPaginated(
      request: DescribeImagesRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeImagesResponse.ReadOnly]
  def createDirectoryConfig(request: CreateDirectoryConfigRequest): IO[
    AwsError,
    zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly
  ]
  def createFleet(
      request: CreateFleetRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateFleetResponse.ReadOnly]
  def expireSession(
      request: ExpireSessionRequest
  ): IO[AwsError, zio.aws.appstream.model.ExpireSessionResponse.ReadOnly]
  def listEntitledApplications(
      request: ListEntitledApplicationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.appstream.model.EntitledApplication.ReadOnly
  ]
  def listEntitledApplicationsPaginated(
      request: ListEntitledApplicationsRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly
  ]
  def createStreamingURL(
      request: CreateStreamingUrlRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly]
  def updateEntitlement(
      request: UpdateEntitlementRequest
  ): IO[AwsError, zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly]
  def disableUser(
      request: DisableUserRequest
  ): IO[AwsError, zio.aws.appstream.model.DisableUserResponse.ReadOnly]
  def disassociateFleet(
      request: DisassociateFleetRequest
  ): IO[AwsError, zio.aws.appstream.model.DisassociateFleetResponse.ReadOnly]
  def createAppBlock(
      request: CreateAppBlockRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly]
  def disassociateApplicationFromEntitlement(
      request: DisassociateApplicationFromEntitlementRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DisassociateApplicationFromEntitlementResponse.ReadOnly
  ]
  def describeUsers(
      request: DescribeUsersRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.User.ReadOnly]
  def describeUsersPaginated(
      request: DescribeUsersRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeUsersResponse.ReadOnly]
  def describeApplicationFleetAssociations(
      request: DescribeApplicationFleetAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
  ]
  def describeApplicationFleetAssociationsPaginated(
      request: DescribeApplicationFleetAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.appstream.model.UntagResourceResponse.ReadOnly]
  def createImageBuilderStreamingURL(
      request: CreateImageBuilderStreamingUrlRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.CreateImageBuilderStreamingUrlResponse.ReadOnly
  ]
  def startImageBuilder(
      request: StartImageBuilderRequest
  ): IO[AwsError, zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly]
  def describeApplications(
      request: DescribeApplicationsRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.Application.ReadOnly]
  def describeApplicationsPaginated(
      request: DescribeApplicationsRequest
  ): IO[AwsError, zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly]
  def enableUser(
      request: EnableUserRequest
  ): IO[AwsError, zio.aws.appstream.model.EnableUserResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.appstream.model.ListTagsForResourceResponse.ReadOnly]
  def copyImage(
      request: CopyImageRequest
  ): IO[AwsError, zio.aws.appstream.model.CopyImageResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.appstream.model.TagResourceResponse.ReadOnly]
  def deleteUser(
      request: DeleteUserRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteUserResponse.ReadOnly]
  def listAssociatedFleets(
      request: ListAssociatedFleetsRequest
  ): ZStream[Any, AwsError, String]
  def listAssociatedFleetsPaginated(
      request: ListAssociatedFleetsRequest
  ): IO[AwsError, zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly]
  def updateStack(request: UpdateStackRequest): IO[AwsError, ReadOnly]
  def deleteStack(
      request: DeleteStackRequest
  ): IO[AwsError, zio.aws.appstream.model.DeleteStackResponse.ReadOnly]
  def updateImagePermissions(request: UpdateImagePermissionsRequest): IO[
    AwsError,
    zio.aws.appstream.model.UpdateImagePermissionsResponse.ReadOnly
  ]
  def deleteImagePermissions(request: DeleteImagePermissionsRequest): IO[
    AwsError,
    zio.aws.appstream.model.DeleteImagePermissionsResponse.ReadOnly
  ]
  def updateApplication(
      request: UpdateApplicationRequest
  ): IO[AwsError, zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly]
  def createStack(
      request: CreateStackRequest
  ): IO[AwsError, zio.aws.appstream.model.CreateStackResponse.ReadOnly]
  def batchDisassociateUserStack(
      request: BatchDisassociateUserStackRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly
  ]
  def describeUserStackAssociations(
      request: DescribeUserStackAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.appstream.model.UserStackAssociation.ReadOnly
  ]
  def describeUserStackAssociationsPaginated(
      request: DescribeUserStackAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly
  ]
  def listAssociatedStacks(
      request: ListAssociatedStacksRequest
  ): ZStream[Any, AwsError, String]
  def listAssociatedStacksPaginated(
      request: ListAssociatedStacksRequest
  ): IO[AwsError, zio.aws.appstream.model.ListAssociatedStacksResponse.ReadOnly]
  def describeDirectoryConfigs(
      request: DescribeDirectoryConfigsRequest
  ): ZStream[Any, AwsError, zio.aws.appstream.model.DirectoryConfig.ReadOnly]
  def describeDirectoryConfigsPaginated(
      request: DescribeDirectoryConfigsRequest
  ): IO[
    AwsError,
    zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly
  ]
  def stopFleet(
      request: StopFleetRequest
  ): IO[AwsError, zio.aws.appstream.model.StopFleetResponse.ReadOnly]
  def updateDirectoryConfig(request: UpdateDirectoryConfigRequest): IO[
    AwsError,
    zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly
  ]
}
object AppStream {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AppStream] = customized(
    identity
  )
  def customized(
      customization: AppStreamAsyncClientBuilder => AppStreamAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AppStream] = managed(
    customization
  ).toLayer
  def managed(
      customization: AppStreamAsyncClientBuilder => AppStreamAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AppStream] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AppStreamAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AppStreamAsyncClient, AppStreamAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[AppStreamAsyncClient, AppStreamAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new AppStreamImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AppStreamImpl[R](
      override val api: AppStreamAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AppStream
      with AwsServiceBase[R] {
    override val serviceName: String = "AppStream"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppStreamImpl[R1] = new AppStreamImpl(api, newAspect, r)
    def describeEntitlements(
        request: DescribeEntitlementsRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.Entitlement.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest,
        DescribeEntitlementsResponse,
        Entitlement
      ](
        "describeEntitlements",
        api.describeEntitlements,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.entitlements().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.Entitlement.wrap(item))
        .provideEnvironment(r)
    def describeEntitlementsPaginated(request: DescribeEntitlementsRequest): IO[
      AwsError,
      zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest,
      DescribeEntitlementsResponse
    ]("describeEntitlements", api.describeEntitlements)(request.buildAwsValue())
      .map(zio.aws.appstream.model.DescribeEntitlementsResponse.wrap)
      .provideEnvironment(r)
    def stopImageBuilder(
        request: StopImageBuilderRequest
    ): IO[AwsError, zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.StopImageBuilderRequest,
        StopImageBuilderResponse
      ]("stopImageBuilder", api.stopImageBuilder)(request.buildAwsValue())
        .map(zio.aws.appstream.model.StopImageBuilderResponse.wrap)
        .provideEnvironment(r)
    def batchAssociateUserStack(request: BatchAssociateUserStackRequest): IO[
      AwsError,
      zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest,
      BatchAssociateUserStackResponse
    ]("batchAssociateUserStack", api.batchAssociateUserStack)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.BatchAssociateUserStackResponse.wrap)
      .provideEnvironment(r)
    def describeStacks(
        request: DescribeStacksRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.Stack.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeStacksRequest,
        DescribeStacksResponse,
        Stack
      ](
        "describeStacks",
        api.describeStacks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.stacks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.Stack.wrap(item))
        .provideEnvironment(r)
    def describeStacksPaginated(
        request: DescribeStacksRequest
    ): IO[AwsError, zio.aws.appstream.model.DescribeStacksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DescribeStacksRequest,
        DescribeStacksResponse
      ]("describeStacks", api.describeStacks)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DescribeStacksResponse.wrap)
        .provideEnvironment(r)
    def deleteApplication(request: DeleteApplicationRequest): IO[
      AwsError,
      zio.aws.appstream.model.DeleteApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue())
      .map(zio.aws.appstream.model.DeleteApplicationResponse.wrap)
      .provideEnvironment(r)
    def describeSessions(
        request: DescribeSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.Session.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest,
        DescribeSessionsResponse,
        Session
      ](
        "describeSessions",
        api.describeSessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.sessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.Session.wrap(item))
        .provideEnvironment(r)
    def describeSessionsPaginated(
        request: DescribeSessionsRequest
    ): IO[AwsError, zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest,
        DescribeSessionsResponse
      ]("describeSessions", api.describeSessions)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DescribeSessionsResponse.wrap)
        .provideEnvironment(r)
    def deleteDirectoryConfig(request: DeleteDirectoryConfigRequest): IO[
      AwsError,
      zio.aws.appstream.model.DeleteDirectoryConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest,
      DeleteDirectoryConfigResponse
    ]("deleteDirectoryConfig", api.deleteDirectoryConfig)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DeleteDirectoryConfigResponse.wrap)
      .provideEnvironment(r)
    def disassociateApplicationFleet(
        request: DisassociateApplicationFleetRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DisassociateApplicationFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest,
      DisassociateApplicationFleetResponse
    ]("disassociateApplicationFleet", api.disassociateApplicationFleet)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DisassociateApplicationFleetResponse.wrap)
      .provideEnvironment(r)
    def describeImagePermissions(
        request: DescribeImagePermissionsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly,
      zio.aws.appstream.model.SharedImagePermissions.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest,
      DescribeImagePermissionsResponse,
      SharedImagePermissions
    ](
      "describeImagePermissions",
      api.describeImagePermissions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.sharedImagePermissionsList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.appstream.model.DescribeImagePermissionsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.appstream.model.SharedImagePermissions.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeImagePermissionsPaginated(
        request: DescribeImagePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest,
      DescribeImagePermissionsResponse
    ]("describeImagePermissions", api.describeImagePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DescribeImagePermissionsResponse.wrap)
      .provideEnvironment(r)
    def createEntitlement(request: CreateEntitlementRequest): IO[
      AwsError,
      zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest,
      CreateEntitlementResponse
    ]("createEntitlement", api.createEntitlement)(request.buildAwsValue())
      .map(zio.aws.appstream.model.CreateEntitlementResponse.wrap)
      .provideEnvironment(r)
    def deleteUsageReportSubscription(
        request: DeleteUsageReportSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DeleteUsageReportSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DeleteUsageReportSubscriptionRequest,
      DeleteUsageReportSubscriptionResponse
    ]("deleteUsageReportSubscription", api.deleteUsageReportSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DeleteUsageReportSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def startFleet(
        request: StartFleetRequest
    ): IO[AwsError, zio.aws.appstream.model.StartFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.StartFleetRequest,
        StartFleetResponse
      ]("startFleet", api.startFleet)(request.buildAwsValue())
        .map(zio.aws.appstream.model.StartFleetResponse.wrap)
        .provideEnvironment(r)
    def createUsageReportSubscription(
        request: CreateUsageReportSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionRequest,
      CreateUsageReportSubscriptionResponse
    ]("createUsageReportSubscription", api.createUsageReportSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def deleteEntitlement(request: DeleteEntitlementRequest): IO[
      AwsError,
      zio.aws.appstream.model.DeleteEntitlementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest,
      DeleteEntitlementResponse
    ]("deleteEntitlement", api.deleteEntitlement)(request.buildAwsValue())
      .map(zio.aws.appstream.model.DeleteEntitlementResponse.wrap)
      .provideEnvironment(r)
    def describeFleets(
        request: DescribeFleetsRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.Fleet.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest,
        DescribeFleetsResponse,
        Fleet
      ](
        "describeFleets",
        api.describeFleets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.fleets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.Fleet.wrap(item))
        .provideEnvironment(r)
    def describeFleetsPaginated(
        request: DescribeFleetsRequest
    ): IO[AwsError, zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest,
        DescribeFleetsResponse
      ]("describeFleets", api.describeFleets)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DescribeFleetsResponse.wrap)
        .provideEnvironment(r)
    def describeUsageReportSubscriptions(
        request: DescribeUsageReportSubscriptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appstream.model.UsageReportSubscription.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsRequest,
      DescribeUsageReportSubscriptionsResponse,
      UsageReportSubscription
    ](
      "describeUsageReportSubscriptions",
      api.describeUsageReportSubscriptions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.usageReportSubscriptions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appstream.model.UsageReportSubscription.wrap(item))
      .provideEnvironment(r)
    def describeUsageReportSubscriptionsPaginated(
        request: DescribeUsageReportSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsRequest,
      DescribeUsageReportSubscriptionsResponse
    ]("describeUsageReportSubscriptions", api.describeUsageReportSubscriptions)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def deleteImage(
        request: DeleteImageRequest
    ): IO[AwsError, zio.aws.appstream.model.DeleteImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DeleteImageRequest,
        DeleteImageResponse
      ]("deleteImage", api.deleteImage)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DeleteImageResponse.wrap)
        .provideEnvironment(r)
    def deleteImageBuilder(request: DeleteImageBuilderRequest): IO[
      AwsError,
      zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest,
      DeleteImageBuilderResponse
    ]("deleteImageBuilder", api.deleteImageBuilder)(request.buildAwsValue())
      .map(zio.aws.appstream.model.DeleteImageBuilderResponse.wrap)
      .provideEnvironment(r)
    def describeImageBuilders(
        request: DescribeImageBuildersRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.ImageBuilder.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeImageBuildersRequest,
        DescribeImageBuildersResponse,
        ImageBuilder
      ](
        "describeImageBuilders",
        api.describeImageBuilders,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.imageBuilders().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.ImageBuilder.wrap(item))
        .provideEnvironment(r)
    def describeImageBuildersPaginated(
        request: DescribeImageBuildersRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeImageBuildersRequest,
      DescribeImageBuildersResponse
    ]("describeImageBuilders", api.describeImageBuilders)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DescribeImageBuildersResponse.wrap)
      .provideEnvironment(r)
    def associateFleet(
        request: AssociateFleetRequest
    ): IO[AwsError, zio.aws.appstream.model.AssociateFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.AssociateFleetRequest,
        AssociateFleetResponse
      ]("associateFleet", api.associateFleet)(request.buildAwsValue())
        .map(zio.aws.appstream.model.AssociateFleetResponse.wrap)
        .provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.appstream.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.appstream.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def createUpdatedImage(request: CreateUpdatedImageRequest): IO[
      AwsError,
      zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest,
      CreateUpdatedImageResponse
    ]("createUpdatedImage", api.createUpdatedImage)(request.buildAwsValue())
      .map(zio.aws.appstream.model.CreateUpdatedImageResponse.wrap)
      .provideEnvironment(r)
    def deleteAppBlock(
        request: DeleteAppBlockRequest
    ): IO[AwsError, zio.aws.appstream.model.DeleteAppBlockResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DeleteAppBlockRequest,
        DeleteAppBlockResponse
      ]("deleteAppBlock", api.deleteAppBlock)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DeleteAppBlockResponse.wrap)
        .provideEnvironment(r)
    def associateApplicationToEntitlement(
        request: AssociateApplicationToEntitlementRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.AssociateApplicationToEntitlementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest,
      AssociateApplicationToEntitlementResponse
    ](
      "associateApplicationToEntitlement",
      api.associateApplicationToEntitlement
    )(request.buildAwsValue())
      .map(
        zio.aws.appstream.model.AssociateApplicationToEntitlementResponse.wrap
      )
      .provideEnvironment(r)
    def describeAppBlocks(request: DescribeAppBlocksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.appstream.model.AppBlock.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest,
      DescribeAppBlocksResponse,
      AppBlock
    ](
      "describeAppBlocks",
      api.describeAppBlocks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.appBlocks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appstream.model.AppBlock.wrap(item))
      .provideEnvironment(r)
    def describeAppBlocksPaginated(request: DescribeAppBlocksRequest): IO[
      AwsError,
      zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest,
      DescribeAppBlocksResponse
    ]("describeAppBlocks", api.describeAppBlocks)(request.buildAwsValue())
      .map(zio.aws.appstream.model.DescribeAppBlocksResponse.wrap)
      .provideEnvironment(r)
    def deleteFleet(
        request: DeleteFleetRequest
    ): IO[AwsError, zio.aws.appstream.model.DeleteFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DeleteFleetRequest,
        DeleteFleetResponse
      ]("deleteFleet", api.deleteFleet)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DeleteFleetResponse.wrap)
        .provideEnvironment(r)
    def associateApplicationFleet(
        request: AssociateApplicationFleetRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetRequest,
      AssociateApplicationFleetResponse
    ]("associateApplicationFleet", api.associateApplicationFleet)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.AssociateApplicationFleetResponse.wrap)
      .provideEnvironment(r)
    def createImageBuilder(request: CreateImageBuilderRequest): IO[
      AwsError,
      zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest,
      CreateImageBuilderResponse
    ]("createImageBuilder", api.createImageBuilder)(request.buildAwsValue())
      .map(zio.aws.appstream.model.CreateImageBuilderResponse.wrap)
      .provideEnvironment(r)
    def createUser(
        request: CreateUserRequest
    ): IO[AwsError, zio.aws.appstream.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.CreateUserRequest,
        CreateUserResponse
      ]("createUser", api.createUser)(request.buildAwsValue())
        .map(zio.aws.appstream.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def updateFleet(
        request: UpdateFleetRequest
    ): IO[AwsError, zio.aws.appstream.model.UpdateFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.UpdateFleetRequest,
        UpdateFleetResponse
      ]("updateFleet", api.updateFleet)(request.buildAwsValue())
        .map(zio.aws.appstream.model.UpdateFleetResponse.wrap)
        .provideEnvironment(r)
    def describeImages(
        request: DescribeImagesRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.Image.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeImagesRequest,
        DescribeImagesResponse,
        Image
      ](
        "describeImages",
        api.describeImages,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.images().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.Image.wrap(item))
        .provideEnvironment(r)
    def describeImagesPaginated(
        request: DescribeImagesRequest
    ): IO[AwsError, zio.aws.appstream.model.DescribeImagesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DescribeImagesRequest,
        DescribeImagesResponse
      ]("describeImages", api.describeImages)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DescribeImagesResponse.wrap)
        .provideEnvironment(r)
    def createDirectoryConfig(request: CreateDirectoryConfigRequest): IO[
      AwsError,
      zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest,
      CreateDirectoryConfigResponse
    ]("createDirectoryConfig", api.createDirectoryConfig)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.CreateDirectoryConfigResponse.wrap)
      .provideEnvironment(r)
    def createFleet(
        request: CreateFleetRequest
    ): IO[AwsError, zio.aws.appstream.model.CreateFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.CreateFleetRequest,
        CreateFleetResponse
      ]("createFleet", api.createFleet)(request.buildAwsValue())
        .map(zio.aws.appstream.model.CreateFleetResponse.wrap)
        .provideEnvironment(r)
    def expireSession(
        request: ExpireSessionRequest
    ): IO[AwsError, zio.aws.appstream.model.ExpireSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.ExpireSessionRequest,
        ExpireSessionResponse
      ]("expireSession", api.expireSession)(request.buildAwsValue())
        .map(zio.aws.appstream.model.ExpireSessionResponse.wrap)
        .provideEnvironment(r)
    def listEntitledApplications(
        request: ListEntitledApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appstream.model.EntitledApplication.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest,
      ListEntitledApplicationsResponse,
      EntitledApplication
    ](
      "listEntitledApplications",
      api.listEntitledApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entitledApplications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appstream.model.EntitledApplication.wrap(item))
      .provideEnvironment(r)
    def listEntitledApplicationsPaginated(
        request: ListEntitledApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest,
      ListEntitledApplicationsResponse
    ]("listEntitledApplications", api.listEntitledApplications)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.ListEntitledApplicationsResponse.wrap)
      .provideEnvironment(r)
    def createStreamingURL(request: CreateStreamingUrlRequest): IO[
      AwsError,
      zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest,
      CreateStreamingUrlResponse
    ]("createStreamingURL", api.createStreamingURL)(request.buildAwsValue())
      .map(zio.aws.appstream.model.CreateStreamingUrlResponse.wrap)
      .provideEnvironment(r)
    def updateEntitlement(request: UpdateEntitlementRequest): IO[
      AwsError,
      zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest,
      UpdateEntitlementResponse
    ]("updateEntitlement", api.updateEntitlement)(request.buildAwsValue())
      .map(zio.aws.appstream.model.UpdateEntitlementResponse.wrap)
      .provideEnvironment(r)
    def disableUser(
        request: DisableUserRequest
    ): IO[AwsError, zio.aws.appstream.model.DisableUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DisableUserRequest,
        DisableUserResponse
      ]("disableUser", api.disableUser)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DisableUserResponse.wrap)
        .provideEnvironment(r)
    def disassociateFleet(request: DisassociateFleetRequest): IO[
      AwsError,
      zio.aws.appstream.model.DisassociateFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest,
      DisassociateFleetResponse
    ]("disassociateFleet", api.disassociateFleet)(request.buildAwsValue())
      .map(zio.aws.appstream.model.DisassociateFleetResponse.wrap)
      .provideEnvironment(r)
    def createAppBlock(
        request: CreateAppBlockRequest
    ): IO[AwsError, zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest,
        CreateAppBlockResponse
      ]("createAppBlock", api.createAppBlock)(request.buildAwsValue())
        .map(zio.aws.appstream.model.CreateAppBlockResponse.wrap)
        .provideEnvironment(r)
    def disassociateApplicationFromEntitlement(
        request: DisassociateApplicationFromEntitlementRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DisassociateApplicationFromEntitlementResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest,
      DisassociateApplicationFromEntitlementResponse
    ](
      "disassociateApplicationFromEntitlement",
      api.disassociateApplicationFromEntitlement
    )(request.buildAwsValue())
      .map(
        zio.aws.appstream.model.DisassociateApplicationFromEntitlementResponse.wrap
      )
      .provideEnvironment(r)
    def describeUsers(
        request: DescribeUsersRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.User.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeUsersRequest,
        DescribeUsersResponse,
        User
      ](
        "describeUsers",
        api.describeUsers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.users().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.User.wrap(item))
        .provideEnvironment(r)
    def describeUsersPaginated(
        request: DescribeUsersRequest
    ): IO[AwsError, zio.aws.appstream.model.DescribeUsersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DescribeUsersRequest,
        DescribeUsersResponse
      ]("describeUsers", api.describeUsers)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DescribeUsersResponse.wrap)
        .provideEnvironment(r)
    def describeApplicationFleetAssociations(
        request: DescribeApplicationFleetAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest,
      DescribeApplicationFleetAssociationsResponse,
      ApplicationFleetAssociation
    ](
      "describeApplicationFleetAssociations",
      api.describeApplicationFleetAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationFleetAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.appstream.model.ApplicationFleetAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def describeApplicationFleetAssociationsPaginated(
        request: DescribeApplicationFleetAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest,
      DescribeApplicationFleetAssociationsResponse
    ](
      "describeApplicationFleetAssociations",
      api.describeApplicationFleetAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.appstream.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.appstream.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createImageBuilderStreamingURL(
        request: CreateImageBuilderStreamingUrlRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.CreateImageBuilderStreamingUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest,
      CreateImageBuilderStreamingUrlResponse
    ]("createImageBuilderStreamingURL", api.createImageBuilderStreamingURL)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.CreateImageBuilderStreamingUrlResponse.wrap)
      .provideEnvironment(r)
    def startImageBuilder(request: StartImageBuilderRequest): IO[
      AwsError,
      zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest,
      StartImageBuilderResponse
    ]("startImageBuilder", api.startImageBuilder)(request.buildAwsValue())
      .map(zio.aws.appstream.model.StartImageBuilderResponse.wrap)
      .provideEnvironment(r)
    def describeApplications(
        request: DescribeApplicationsRequest
    ): ZStream[Any, AwsError, zio.aws.appstream.model.Application.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appstream.model.DescribeApplicationsRequest,
        DescribeApplicationsResponse,
        Application
      ](
        "describeApplications",
        api.describeApplications,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.applications().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appstream.model.Application.wrap(item))
        .provideEnvironment(r)
    def describeApplicationsPaginated(request: DescribeApplicationsRequest): IO[
      AwsError,
      zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeApplicationsRequest,
      DescribeApplicationsResponse
    ]("describeApplications", api.describeApplications)(request.buildAwsValue())
      .map(zio.aws.appstream.model.DescribeApplicationsResponse.wrap)
      .provideEnvironment(r)
    def enableUser(
        request: EnableUserRequest
    ): IO[AwsError, zio.aws.appstream.model.EnableUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.EnableUserRequest,
        EnableUserResponse
      ]("enableUser", api.enableUser)(request.buildAwsValue())
        .map(zio.aws.appstream.model.EnableUserResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.appstream.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.appstream.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def copyImage(
        request: CopyImageRequest
    ): IO[AwsError, zio.aws.appstream.model.CopyImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.CopyImageRequest,
        CopyImageResponse
      ]("copyImage", api.copyImage)(request.buildAwsValue())
        .map(zio.aws.appstream.model.CopyImageResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.appstream.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.appstream.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteUser(
        request: DeleteUserRequest
    ): IO[AwsError, zio.aws.appstream.model.DeleteUserResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DeleteUserRequest,
        DeleteUserResponse
      ]("deleteUser", api.deleteUser)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DeleteUserResponse.wrap)
        .provideEnvironment(r)
    def listAssociatedFleets(
        request: ListAssociatedFleetsRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest,
      ListAssociatedFleetsResponse,
      java.lang.String
    ](
      "listAssociatedFleets",
      api.listAssociatedFleets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.names().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listAssociatedFleetsPaginated(request: ListAssociatedFleetsRequest): IO[
      AwsError,
      zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest,
      ListAssociatedFleetsResponse
    ]("listAssociatedFleets", api.listAssociatedFleets)(request.buildAwsValue())
      .map(zio.aws.appstream.model.ListAssociatedFleetsResponse.wrap)
      .provideEnvironment(r)
    def updateStack(request: UpdateStackRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.UpdateStackRequest,
        UpdateStackResponse
      ]("updateStack", api.updateStack)(request.buildAwsValue())
        .map(zio.aws.appstream.model.UpdateStackResponse.wrap)
        .provideEnvironment(r)
    def deleteStack(
        request: DeleteStackRequest
    ): IO[AwsError, zio.aws.appstream.model.DeleteStackResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.DeleteStackRequest,
        DeleteStackResponse
      ]("deleteStack", api.deleteStack)(request.buildAwsValue())
        .map(zio.aws.appstream.model.DeleteStackResponse.wrap)
        .provideEnvironment(r)
    def updateImagePermissions(request: UpdateImagePermissionsRequest): IO[
      AwsError,
      zio.aws.appstream.model.UpdateImagePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest,
      UpdateImagePermissionsResponse
    ]("updateImagePermissions", api.updateImagePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.UpdateImagePermissionsResponse.wrap)
      .provideEnvironment(r)
    def deleteImagePermissions(request: DeleteImagePermissionsRequest): IO[
      AwsError,
      zio.aws.appstream.model.DeleteImagePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest,
      DeleteImagePermissionsResponse
    ]("deleteImagePermissions", api.deleteImagePermissions)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DeleteImagePermissionsResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(request: UpdateApplicationRequest): IO[
      AwsError,
      zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(zio.aws.appstream.model.UpdateApplicationResponse.wrap)
      .provideEnvironment(r)
    def createStack(
        request: CreateStackRequest
    ): IO[AwsError, zio.aws.appstream.model.CreateStackResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.CreateStackRequest,
        CreateStackResponse
      ]("createStack", api.createStack)(request.buildAwsValue())
        .map(zio.aws.appstream.model.CreateStackResponse.wrap)
        .provideEnvironment(r)
    def batchDisassociateUserStack(
        request: BatchDisassociateUserStackRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest,
      BatchDisassociateUserStackResponse
    ]("batchDisassociateUserStack", api.batchDisassociateUserStack)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.BatchDisassociateUserStackResponse.wrap)
      .provideEnvironment(r)
    def describeUserStackAssociations(
        request: DescribeUserStackAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appstream.model.UserStackAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest,
      DescribeUserStackAssociationsResponse,
      UserStackAssociation
    ](
      "describeUserStackAssociations",
      api.describeUserStackAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.userStackAssociations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appstream.model.UserStackAssociation.wrap(item))
      .provideEnvironment(r)
    def describeUserStackAssociationsPaginated(
        request: DescribeUserStackAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest,
      DescribeUserStackAssociationsResponse
    ]("describeUserStackAssociations", api.describeUserStackAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DescribeUserStackAssociationsResponse.wrap)
      .provideEnvironment(r)
    def listAssociatedStacks(
        request: ListAssociatedStacksRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest,
      ListAssociatedStacksResponse,
      java.lang.String
    ](
      "listAssociatedStacks",
      api.listAssociatedStacks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.names().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listAssociatedStacksPaginated(request: ListAssociatedStacksRequest): IO[
      AwsError,
      zio.aws.appstream.model.ListAssociatedStacksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest,
      ListAssociatedStacksResponse
    ]("listAssociatedStacks", api.listAssociatedStacks)(request.buildAwsValue())
      .map(zio.aws.appstream.model.ListAssociatedStacksResponse.wrap)
      .provideEnvironment(r)
    def describeDirectoryConfigs(
        request: DescribeDirectoryConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appstream.model.DirectoryConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest,
      DescribeDirectoryConfigsResponse,
      DirectoryConfig
    ](
      "describeDirectoryConfigs",
      api.describeDirectoryConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.directoryConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appstream.model.DirectoryConfig.wrap(item))
      .provideEnvironment(r)
    def describeDirectoryConfigsPaginated(
        request: DescribeDirectoryConfigsRequest
    ): IO[
      AwsError,
      zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest,
      DescribeDirectoryConfigsResponse
    ]("describeDirectoryConfigs", api.describeDirectoryConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.DescribeDirectoryConfigsResponse.wrap)
      .provideEnvironment(r)
    def stopFleet(
        request: StopFleetRequest
    ): IO[AwsError, zio.aws.appstream.model.StopFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appstream.model.StopFleetRequest,
        StopFleetResponse
      ]("stopFleet", api.stopFleet)(request.buildAwsValue())
        .map(zio.aws.appstream.model.StopFleetResponse.wrap)
        .provideEnvironment(r)
    def updateDirectoryConfig(request: UpdateDirectoryConfigRequest): IO[
      AwsError,
      zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest,
      UpdateDirectoryConfigResponse
    ]("updateDirectoryConfig", api.updateDirectoryConfig)(
      request.buildAwsValue()
    ).map(zio.aws.appstream.model.UpdateDirectoryConfigResponse.wrap)
      .provideEnvironment(r)
  }
  def describeEntitlements(request: DescribeEntitlementsRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.Entitlement.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEntitlements(request))
  def describeEntitlementsPaginated(request: DescribeEntitlementsRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeEntitlementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEntitlementsPaginated(request))
  def stopImageBuilder(request: StopImageBuilderRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.StopImageBuilderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopImageBuilder(request))
  def batchAssociateUserStack(request: BatchAssociateUserStackRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.BatchAssociateUserStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchAssociateUserStack(request))
  def describeStacks(request: DescribeStacksRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.Stack.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStacks(request))
  def describeStacksPaginated(request: DescribeStacksRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeStacksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStacksPaginated(request))
  def deleteApplication(request: DeleteApplicationRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def describeSessions(request: DescribeSessionsRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.Session.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSessions(request))
  def describeSessionsPaginated(request: DescribeSessionsRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSessionsPaginated(request))
  def deleteDirectoryConfig(request: DeleteDirectoryConfigRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteDirectoryConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDirectoryConfig(request))
  def disassociateApplicationFleet(
      request: DisassociateApplicationFleetRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DisassociateApplicationFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateApplicationFleet(request))
  def describeImagePermissions(
      request: DescribeImagePermissionsRequest
  ): ZIO[zio.aws.appstream.AppStream, AwsError, StreamingOutputResult[
    Any,
    zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly,
    zio.aws.appstream.model.SharedImagePermissions.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeImagePermissions(request))
  def describeImagePermissionsPaginated(
      request: DescribeImagePermissionsRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeImagePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImagePermissionsPaginated(request))
  def createEntitlement(request: CreateEntitlementRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateEntitlementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEntitlement(request))
  def deleteUsageReportSubscription(
      request: DeleteUsageReportSubscriptionRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteUsageReportSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUsageReportSubscription(request))
  def startFleet(request: StartFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.StartFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startFleet(request))
  def createUsageReportSubscription(
      request: CreateUsageReportSubscriptionRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateUsageReportSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUsageReportSubscription(request))
  def deleteEntitlement(request: DeleteEntitlementRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteEntitlementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEntitlement(request))
  def describeFleets(request: DescribeFleetsRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.Fleet.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleets(request))
  def describeFleetsPaginated(request: DescribeFleetsRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetsPaginated(request))
  def describeUsageReportSubscriptions(
      request: DescribeUsageReportSubscriptionsRequest
  ): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UsageReportSubscription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUsageReportSubscriptions(request))
  def describeUsageReportSubscriptionsPaginated(
      request: DescribeUsageReportSubscriptionsRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeUsageReportSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUsageReportSubscriptionsPaginated(request))
  def deleteImage(request: DeleteImageRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImage(request))
  def deleteImageBuilder(request: DeleteImageBuilderRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteImageBuilderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImageBuilder(request))
  def describeImageBuilders(request: DescribeImageBuildersRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.ImageBuilder.ReadOnly
  ] = ZStream.serviceWithStream(_.describeImageBuilders(request))
  def describeImageBuildersPaginated(
      request: DescribeImageBuildersRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeImageBuildersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImageBuildersPaginated(request))
  def associateFleet(request: AssociateFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.AssociateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateFleet(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def createUpdatedImage(request: CreateUpdatedImageRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateUpdatedImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUpdatedImage(request))
  def deleteAppBlock(request: DeleteAppBlockRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteAppBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAppBlock(request))
  def associateApplicationToEntitlement(
      request: AssociateApplicationToEntitlementRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.AssociateApplicationToEntitlementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateApplicationToEntitlement(request))
  def describeAppBlocks(request: DescribeAppBlocksRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.AppBlock.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAppBlocks(request))
  def describeAppBlocksPaginated(request: DescribeAppBlocksRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeAppBlocksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAppBlocksPaginated(request))
  def deleteFleet(request: DeleteFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFleet(request))
  def associateApplicationFleet(request: AssociateApplicationFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.AssociateApplicationFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateApplicationFleet(request))
  def createImageBuilder(request: CreateImageBuilderRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateImageBuilderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImageBuilder(request))
  def createUser(request: CreateUserRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def updateFleet(request: UpdateFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UpdateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFleet(request))
  def describeImages(request: DescribeImagesRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.Image.ReadOnly
  ] = ZStream.serviceWithStream(_.describeImages(request))
  def describeImagesPaginated(request: DescribeImagesRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImagesPaginated(request))
  def createDirectoryConfig(request: CreateDirectoryConfigRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateDirectoryConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDirectoryConfig(request))
  def createFleet(request: CreateFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleet(request))
  def expireSession(request: ExpireSessionRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.ExpireSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.expireSession(request))
  def listEntitledApplications(
      request: ListEntitledApplicationsRequest
  ): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.EntitledApplication.ReadOnly
  ] = ZStream.serviceWithStream(_.listEntitledApplications(request))
  def listEntitledApplicationsPaginated(
      request: ListEntitledApplicationsRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.ListEntitledApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEntitledApplicationsPaginated(request))
  def createStreamingURL(request: CreateStreamingUrlRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateStreamingUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamingURL(request))
  def updateEntitlement(request: UpdateEntitlementRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UpdateEntitlementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEntitlement(request))
  def disableUser(request: DisableUserRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DisableUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableUser(request))
  def disassociateFleet(request: DisassociateFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DisassociateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFleet(request))
  def createAppBlock(request: CreateAppBlockRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateAppBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAppBlock(request))
  def disassociateApplicationFromEntitlement(
      request: DisassociateApplicationFromEntitlementRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DisassociateApplicationFromEntitlementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateApplicationFromEntitlement(request))
  def describeUsers(request: DescribeUsersRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.User.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUsers(request))
  def describeUsersPaginated(request: DescribeUsersRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUsersPaginated(request))
  def describeApplicationFleetAssociations(
      request: DescribeApplicationFleetAssociationsRequest
  ): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.ApplicationFleetAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeApplicationFleetAssociations(request))
  def describeApplicationFleetAssociationsPaginated(
      request: DescribeApplicationFleetAssociationsRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeApplicationFleetAssociationsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeApplicationFleetAssociationsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createImageBuilderStreamingURL(
      request: CreateImageBuilderStreamingUrlRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateImageBuilderStreamingUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImageBuilderStreamingURL(request))
  def startImageBuilder(request: StartImageBuilderRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.StartImageBuilderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startImageBuilder(request))
  def describeApplications(request: DescribeApplicationsRequest): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.Application.ReadOnly
  ] = ZStream.serviceWithStream(_.describeApplications(request))
  def describeApplicationsPaginated(request: DescribeApplicationsRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicationsPaginated(request))
  def enableUser(request: EnableUserRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.EnableUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableUser(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def copyImage(request: CopyImageRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CopyImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyImage(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteUser(request: DeleteUserRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUser(request))
  def listAssociatedFleets(
      request: ListAssociatedFleetsRequest
  ): ZStream[zio.aws.appstream.AppStream, AwsError, String] =
    ZStream.serviceWithStream(_.listAssociatedFleets(request))
  def listAssociatedFleetsPaginated(request: ListAssociatedFleetsRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssociatedFleetsPaginated(request))
  def updateStack(
      request: UpdateStackRequest
  ): ZIO[zio.aws.appstream.AppStream, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateStack(request))
  def deleteStack(request: DeleteStackRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStack(request))
  def updateImagePermissions(request: UpdateImagePermissionsRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UpdateImagePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateImagePermissions(request))
  def deleteImagePermissions(request: DeleteImagePermissionsRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DeleteImagePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImagePermissions(request))
  def updateApplication(request: UpdateApplicationRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def createStack(request: CreateStackRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.CreateStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStack(request))
  def batchDisassociateUserStack(
      request: BatchDisassociateUserStackRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.BatchDisassociateUserStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDisassociateUserStack(request))
  def describeUserStackAssociations(
      request: DescribeUserStackAssociationsRequest
  ): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UserStackAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeUserStackAssociations(request))
  def describeUserStackAssociationsPaginated(
      request: DescribeUserStackAssociationsRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeUserStackAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserStackAssociationsPaginated(request))
  def listAssociatedStacks(
      request: ListAssociatedStacksRequest
  ): ZStream[zio.aws.appstream.AppStream, AwsError, String] =
    ZStream.serviceWithStream(_.listAssociatedStacks(request))
  def listAssociatedStacksPaginated(request: ListAssociatedStacksRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.ListAssociatedStacksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssociatedStacksPaginated(request))
  def describeDirectoryConfigs(
      request: DescribeDirectoryConfigsRequest
  ): ZStream[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DirectoryConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDirectoryConfigs(request))
  def describeDirectoryConfigsPaginated(
      request: DescribeDirectoryConfigsRequest
  ): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.DescribeDirectoryConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDirectoryConfigsPaginated(request))
  def stopFleet(request: StopFleetRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.StopFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopFleet(request))
  def updateDirectoryConfig(request: UpdateDirectoryConfigRequest): ZIO[
    zio.aws.appstream.AppStream,
    AwsError,
    zio.aws.appstream.model.UpdateDirectoryConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDirectoryConfig(request))
}
