package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait VisibilityType {
  def unwrap: software.amazon.awssdk.services.appstream.model.VisibilityType
}
object VisibilityType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.VisibilityType
  ): zio.aws.appstream.model.VisibilityType = value match {
    case software.amazon.awssdk.services.appstream.model.VisibilityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.VisibilityType.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.appstream.model.VisibilityType.PRIVATE =>
      val r = PRIVATE
      r
    case software.amazon.awssdk.services.appstream.model.VisibilityType.SHARED =>
      val r = SHARED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appstream.model.VisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.VisibilityType =
      software.amazon.awssdk.services.appstream.model.VisibilityType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.appstream.model.VisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.VisibilityType =
      software.amazon.awssdk.services.appstream.model.VisibilityType.PUBLIC
  }
  case object PRIVATE extends zio.aws.appstream.model.VisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.VisibilityType =
      software.amazon.awssdk.services.appstream.model.VisibilityType.PRIVATE
  }
  case object SHARED extends zio.aws.appstream.model.VisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.VisibilityType =
      software.amazon.awssdk.services.appstream.model.VisibilityType.SHARED
  }
}
