package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserStackAssociationError(
    userStackAssociation: Option[zio.aws.appstream.model.UserStackAssociation] =
      None,
    errorCode: Option[zio.aws.appstream.model.UserStackAssociationErrorCode] =
      None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UserStackAssociationError = {
    import UserStackAssociationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UserStackAssociationError
      .builder()
      .optionallyWith(userStackAssociation.map(value => value.buildAwsValue()))(
        _.userStackAssociation
      )
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.UserStackAssociationError.ReadOnly =
    zio.aws.appstream.model.UserStackAssociationError.wrap(buildAwsValue())
}
object UserStackAssociationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UserStackAssociationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UserStackAssociationError =
      zio.aws.appstream.model.UserStackAssociationError(
        userStackAssociation.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def userStackAssociation
        : Option[zio.aws.appstream.model.UserStackAssociation.ReadOnly]
    def errorCode: Option[zio.aws.appstream.model.UserStackAssociationErrorCode]
    def errorMessage: Option[String]
    def getUserStackAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.UserStackAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("userStackAssociation", userStackAssociation)
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.UserStackAssociationErrorCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UserStackAssociationError
  ) extends zio.aws.appstream.model.UserStackAssociationError.ReadOnly {
    override val userStackAssociation
        : Option[zio.aws.appstream.model.UserStackAssociation.ReadOnly] = scala
      .Option(impl.userStackAssociation())
      .map(value => zio.aws.appstream.model.UserStackAssociation.wrap(value))
    override val errorCode
        : Option[zio.aws.appstream.model.UserStackAssociationErrorCode] = scala
      .Option(impl.errorCode())
      .map(value =>
        zio.aws.appstream.model.UserStackAssociationErrorCode.wrap(value)
      )
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UserStackAssociationError
  ): zio.aws.appstream.model.UserStackAssociationError.ReadOnly = new Wrapper(
    impl
  )
}
