package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  OrganizationalUnitDistinguishedName,
  DirectoryName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDirectoryConfigRequest(
    directoryName: DirectoryName,
    organizationalUnitDistinguishedNames: Option[
      Iterable[OrganizationalUnitDistinguishedName]
    ] = None,
    serviceAccountCredentials: Option[
      zio.aws.appstream.model.ServiceAccountCredentials
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest = {
    import UpdateDirectoryConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest
      .builder()
      .directoryName(DirectoryName.unwrap(directoryName): java.lang.String)
      .optionallyWith(
        organizationalUnitDistinguishedNames.map(value =>
          value.map { item =>
            OrganizationalUnitDistinguishedName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitDistinguishedNames)
      .optionallyWith(
        serviceAccountCredentials.map(value => value.buildAwsValue())
      )(_.serviceAccountCredentials)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.UpdateDirectoryConfigRequest.ReadOnly =
    zio.aws.appstream.model.UpdateDirectoryConfigRequest.wrap(buildAwsValue())
}
object UpdateDirectoryConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.UpdateDirectoryConfigRequest =
      zio.aws.appstream.model.UpdateDirectoryConfigRequest(
        directoryName,
        organizationalUnitDistinguishedNames.map(value => value),
        serviceAccountCredentials.map(value => value.asEditable)
      )
    def directoryName: DirectoryName
    def organizationalUnitDistinguishedNames
        : Option[List[OrganizationalUnitDistinguishedName]]
    def serviceAccountCredentials
        : Option[zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly]
    def getDirectoryName: ZIO[Any, Nothing, DirectoryName] =
      ZIO.succeed(directoryName)
    def getOrganizationalUnitDistinguishedNames
        : ZIO[Any, AwsError, List[OrganizationalUnitDistinguishedName]] =
      AwsError.unwrapOptionField(
        "organizationalUnitDistinguishedNames",
        organizationalUnitDistinguishedNames
      )
    def getServiceAccountCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceAccountCredentials",
      serviceAccountCredentials
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest
  ) extends zio.aws.appstream.model.UpdateDirectoryConfigRequest.ReadOnly {
    override val directoryName: DirectoryName =
      zio.aws.appstream.model.primitives.DirectoryName(impl.directoryName())
    override val organizationalUnitDistinguishedNames
        : Option[List[OrganizationalUnitDistinguishedName]] = scala
      .Option(impl.organizationalUnitDistinguishedNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives
            .OrganizationalUnitDistinguishedName(item)
        }.toList
      )
    override val serviceAccountCredentials
        : Option[zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly] =
      scala
        .Option(impl.serviceAccountCredentials())
        .map(value =>
          zio.aws.appstream.model.ServiceAccountCredentials.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest
  ): zio.aws.appstream.model.UpdateDirectoryConfigRequest.ReadOnly =
    new Wrapper(impl)
}
