package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.AppstreamAgentVersion
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartImageBuilderRequest(
    name: String,
    appstreamAgentVersion: Option[AppstreamAgentVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest = {
    import StartImageBuilderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(
        appstreamAgentVersion.map(value =>
          AppstreamAgentVersion.unwrap(value): java.lang.String
        )
      )(_.appstreamAgentVersion)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StartImageBuilderRequest.ReadOnly =
    zio.aws.appstream.model.StartImageBuilderRequest.wrap(buildAwsValue())
}
object StartImageBuilderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StartImageBuilderRequest =
      zio.aws.appstream.model.StartImageBuilderRequest(
        name,
        appstreamAgentVersion.map(value => value)
      )
    def name: String
    def appstreamAgentVersion: Option[AppstreamAgentVersion]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getAppstreamAgentVersion: ZIO[Any, AwsError, AppstreamAgentVersion] =
      AwsError.unwrapOptionField("appstreamAgentVersion", appstreamAgentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest
  ) extends zio.aws.appstream.model.StartImageBuilderRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val appstreamAgentVersion: Option[AppstreamAgentVersion] = scala
      .Option(impl.appstreamAgentVersion())
      .map(value =>
        zio.aws.appstream.model.primitives.AppstreamAgentVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest
  ): zio.aws.appstream.model.StartImageBuilderRequest.ReadOnly = new Wrapper(
    impl
  )
}
