package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StackError(
    errorCode: Option[zio.aws.appstream.model.StackErrorCode] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.StackError = {
    import StackError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.StackError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.StackError.ReadOnly =
    zio.aws.appstream.model.StackError.wrap(buildAwsValue())
}
object StackError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.StackError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.StackError =
      zio.aws.appstream.model.StackError(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Option[zio.aws.appstream.model.StackErrorCode]
    def errorMessage: Option[String]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.appstream.model.StackErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.StackError
  ) extends zio.aws.appstream.model.StackError.ReadOnly {
    override val errorCode: Option[zio.aws.appstream.model.StackErrorCode] =
      scala
        .Option(impl.errorCode())
        .map(value => zio.aws.appstream.model.StackErrorCode.wrap(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.StackError
  ): zio.aws.appstream.model.StackError.ReadOnly = new Wrapper(impl)
}
