package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  Timestamp,
  Arn,
  RedirectURL,
  EmbedHostDomain,
  FeedbackURL
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Stack(
    arn: Option[Arn] = None,
    name: String,
    description: Option[String] = None,
    displayName: Option[String] = None,
    createdTime: Option[Timestamp] = None,
    storageConnectors: Option[
      Iterable[zio.aws.appstream.model.StorageConnector]
    ] = None,
    redirectURL: Option[RedirectURL] = None,
    feedbackURL: Option[FeedbackURL] = None,
    stackErrors: Option[Iterable[zio.aws.appstream.model.StackError]] = None,
    userSettings: Option[Iterable[zio.aws.appstream.model.UserSetting]] = None,
    applicationSettings: Option[
      zio.aws.appstream.model.ApplicationSettingsResponse
    ] = None,
    accessEndpoints: Option[Iterable[zio.aws.appstream.model.AccessEndpoint]] =
      None,
    embedHostDomains: Option[Iterable[EmbedHostDomain]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.appstream.model.Stack = {
    import Stack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Stack
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        storageConnectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageConnectors)
      .optionallyWith(
        redirectURL.map(value => RedirectURL.unwrap(value): java.lang.String)
      )(_.redirectURL)
      .optionallyWith(
        feedbackURL.map(value => FeedbackURL.unwrap(value): java.lang.String)
      )(_.feedbackURL)
      .optionallyWith(
        stackErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stackErrors)
      .optionallyWith(
        userSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userSettings)
      .optionallyWith(applicationSettings.map(value => value.buildAwsValue()))(
        _.applicationSettings
      )
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .optionallyWith(
        embedHostDomains.map(value =>
          value.map { item =>
            EmbedHostDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.embedHostDomains)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Stack.ReadOnly =
    zio.aws.appstream.model.Stack.wrap(buildAwsValue())
}
object Stack {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.Stack] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Stack =
      zio.aws.appstream.model.Stack(
        arn.map(value => value),
        name,
        description.map(value => value),
        displayName.map(value => value),
        createdTime.map(value => value),
        storageConnectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        redirectURL.map(value => value),
        feedbackURL.map(value => value),
        stackErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationSettings.map(value => value.asEditable),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        embedHostDomains.map(value => value)
      )
    def arn: Option[Arn]
    def name: String
    def description: Option[String]
    def displayName: Option[String]
    def createdTime: Option[Timestamp]
    def storageConnectors
        : Option[List[zio.aws.appstream.model.StorageConnector.ReadOnly]]
    def redirectURL: Option[RedirectURL]
    def feedbackURL: Option[FeedbackURL]
    def stackErrors: Option[List[zio.aws.appstream.model.StackError.ReadOnly]]
    def userSettings: Option[List[zio.aws.appstream.model.UserSetting.ReadOnly]]
    def applicationSettings
        : Option[zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly]
    def accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def embedHostDomains: Option[List[EmbedHostDomain]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getStorageConnectors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.StorageConnector.ReadOnly
    ]] = AwsError.unwrapOptionField("storageConnectors", storageConnectors)
    def getRedirectURL: ZIO[Any, AwsError, RedirectURL] =
      AwsError.unwrapOptionField("redirectURL", redirectURL)
    def getFeedbackURL: ZIO[Any, AwsError, FeedbackURL] =
      AwsError.unwrapOptionField("feedbackURL", feedbackURL)
    def getStackErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.StackError.ReadOnly
    ]] = AwsError.unwrapOptionField("stackErrors", stackErrors)
    def getUserSettings: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.UserSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("userSettings", userSettings)
    def getApplicationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly
    ] = AwsError.unwrapOptionField("applicationSettings", applicationSettings)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
    def getEmbedHostDomains: ZIO[Any, AwsError, List[EmbedHostDomain]] =
      AwsError.unwrapOptionField("embedHostDomains", embedHostDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Stack
  ) extends zio.aws.appstream.model.Stack.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val name: String = impl.name(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val displayName: Option[String] =
      scala.Option(impl.displayName()).map(value => value: String)
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val storageConnectors
        : Option[List[zio.aws.appstream.model.StorageConnector.ReadOnly]] =
      scala
        .Option(impl.storageConnectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appstream.model.StorageConnector.wrap(item)
          }.toList
        )
    override val redirectURL: Option[RedirectURL] = scala
      .Option(impl.redirectURL())
      .map(value => zio.aws.appstream.model.primitives.RedirectURL(value))
    override val feedbackURL: Option[FeedbackURL] = scala
      .Option(impl.feedbackURL())
      .map(value => zio.aws.appstream.model.primitives.FeedbackURL(value))
    override val stackErrors
        : Option[List[zio.aws.appstream.model.StackError.ReadOnly]] = scala
      .Option(impl.stackErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.StackError.wrap(item)
        }.toList
      )
    override val userSettings
        : Option[List[zio.aws.appstream.model.UserSetting.ReadOnly]] = scala
      .Option(impl.userSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.UserSetting.wrap(item)
        }.toList
      )
    override val applicationSettings
        : Option[zio.aws.appstream.model.ApplicationSettingsResponse.ReadOnly] =
      scala
        .Option(impl.applicationSettings())
        .map(value =>
          zio.aws.appstream.model.ApplicationSettingsResponse.wrap(value)
        )
    override val accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] = scala
      .Option(impl.accessEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.AccessEndpoint.wrap(item)
        }.toList
      )
    override val embedHostDomains: Option[List[EmbedHostDomain]] = scala
      .Option(impl.embedHostDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.primitives.EmbedHostDomain(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Stack
  ): zio.aws.appstream.model.Stack.ReadOnly = new Wrapper(impl)
}
