package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{AccountPassword, AccountName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ServiceAccountCredentials(
    accountName: AccountName,
    accountPassword: AccountPassword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials = {
    import ServiceAccountCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials
      .builder()
      .accountName(AccountName.unwrap(accountName): java.lang.String)
      .accountPassword(
        AccountPassword.unwrap(accountPassword): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly =
    zio.aws.appstream.model.ServiceAccountCredentials.wrap(buildAwsValue())
}
object ServiceAccountCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ServiceAccountCredentials =
      zio.aws.appstream.model
        .ServiceAccountCredentials(accountName, accountPassword)
    def accountName: AccountName
    def accountPassword: AccountPassword
    def getAccountName: ZIO[Any, Nothing, AccountName] =
      ZIO.succeed(accountName)
    def getAccountPassword: ZIO[Any, Nothing, AccountPassword] =
      ZIO.succeed(accountPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials
  ) extends zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly {
    override val accountName: AccountName =
      zio.aws.appstream.model.primitives.AccountName(impl.accountName())
    override val accountPassword: AccountPassword =
      zio.aws.appstream.model.primitives.AccountPassword(impl.accountPassword())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials
  ): zio.aws.appstream.model.ServiceAccountCredentials.ReadOnly = new Wrapper(
    impl
  )
}
