package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkAccessConfiguration(
    eniPrivateIpAddress: Option[String] = None,
    eniId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration = {
    import NetworkAccessConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
      .builder()
      .optionallyWith(
        eniPrivateIpAddress.map(value => value: java.lang.String)
      )(_.eniPrivateIpAddress)
      .optionallyWith(eniId.map(value => value: java.lang.String))(_.eniId)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly =
    zio.aws.appstream.model.NetworkAccessConfiguration.wrap(buildAwsValue())
}
object NetworkAccessConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.NetworkAccessConfiguration =
      zio.aws.appstream.model.NetworkAccessConfiguration(
        eniPrivateIpAddress.map(value => value),
        eniId.map(value => value)
      )
    def eniPrivateIpAddress: Option[String]
    def eniId: Option[String]
    def getEniPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eniPrivateIpAddress", eniPrivateIpAddress)
    def getEniId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eniId", eniId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
  ) extends zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly {
    override val eniPrivateIpAddress: Option[String] =
      scala.Option(impl.eniPrivateIpAddress()).map(value => value: String)
    override val eniId: Option[String] =
      scala.Option(impl.eniId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.NetworkAccessConfiguration
  ): zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
