package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssociatedFleetsResponse(
    names: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse = {
    import ListAssociatedFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly =
    zio.aws.appstream.model.ListAssociatedFleetsResponse.wrap(buildAwsValue())
}
object ListAssociatedFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ListAssociatedFleetsResponse =
      zio.aws.appstream.model.ListAssociatedFleetsResponse(
        names.map(value => value),
        nextToken.map(value => value)
      )
    def names: Option[List[String]]
    def nextToken: Option[String]
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse
  ) extends zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly {
    override val names: Option[List[String]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse
  ): zio.aws.appstream.model.ListAssociatedFleetsResponse.ReadOnly =
    new Wrapper(impl)
}
