package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageBuilderStateChangeReason(
    code: Option[zio.aws.appstream.model.ImageBuilderStateChangeReasonCode] =
      None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReason = {
    import ImageBuilderStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly =
    zio.aws.appstream.model.ImageBuilderStateChangeReason.wrap(buildAwsValue())
}
object ImageBuilderStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ImageBuilderStateChangeReason =
      zio.aws.appstream.model.ImageBuilderStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.appstream.model.ImageBuilderStateChangeReasonCode]
    def message: Option[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ImageBuilderStateChangeReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReason
  ) extends zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly {
    override val code
        : Option[zio.aws.appstream.model.ImageBuilderStateChangeReasonCode] =
      scala
        .Option(impl.code())
        .map(value =>
          zio.aws.appstream.model.ImageBuilderStateChangeReasonCode.wrap(value)
        )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ImageBuilderStateChangeReason
  ): zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly =
    new Wrapper(impl)
}
