package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  AppstreamAgentVersion,
  BooleanObject,
  Timestamp,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ImageBuilder(
    name: String,
    arn: Option[Arn] = None,
    imageArn: Option[Arn] = None,
    description: Option[String] = None,
    displayName: Option[String] = None,
    vpcConfig: Option[zio.aws.appstream.model.VpcConfig] = None,
    instanceType: Option[String] = None,
    platform: Option[zio.aws.appstream.model.PlatformType] = None,
    iamRoleArn: Option[Arn] = None,
    state: Option[zio.aws.appstream.model.ImageBuilderState] = None,
    stateChangeReason: Option[
      zio.aws.appstream.model.ImageBuilderStateChangeReason
    ] = None,
    createdTime: Option[Timestamp] = None,
    enableDefaultInternetAccess: Option[BooleanObject] = None,
    domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo] = None,
    networkAccessConfiguration: Option[
      zio.aws.appstream.model.NetworkAccessConfiguration
    ] = None,
    imageBuilderErrors: Option[
      Iterable[zio.aws.appstream.model.ResourceError]
    ] = None,
    appstreamAgentVersion: Option[AppstreamAgentVersion] = None,
    accessEndpoints: Option[Iterable[zio.aws.appstream.model.AccessEndpoint]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.ImageBuilder = {
    import ImageBuilder.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.ImageBuilder
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        iamRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        enableDefaultInternetAccess.map(value => value: java.lang.Boolean)
      )(_.enableDefaultInternetAccess)
      .optionallyWith(domainJoinInfo.map(value => value.buildAwsValue()))(
        _.domainJoinInfo
      )
      .optionallyWith(
        networkAccessConfiguration.map(value => value.buildAwsValue())
      )(_.networkAccessConfiguration)
      .optionallyWith(
        imageBuilderErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageBuilderErrors)
      .optionallyWith(
        appstreamAgentVersion.map(value =>
          AppstreamAgentVersion.unwrap(value): java.lang.String
        )
      )(_.appstreamAgentVersion)
      .optionallyWith(
        accessEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.ImageBuilder.ReadOnly =
    zio.aws.appstream.model.ImageBuilder.wrap(buildAwsValue())
}
object ImageBuilder {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.ImageBuilder
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.ImageBuilder =
      zio.aws.appstream.model.ImageBuilder(
        name,
        arn.map(value => value),
        imageArn.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        vpcConfig.map(value => value.asEditable),
        instanceType.map(value => value),
        platform.map(value => value),
        iamRoleArn.map(value => value),
        state.map(value => value),
        stateChangeReason.map(value => value.asEditable),
        createdTime.map(value => value),
        enableDefaultInternetAccess.map(value => value),
        domainJoinInfo.map(value => value.asEditable),
        networkAccessConfiguration.map(value => value.asEditable),
        imageBuilderErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        appstreamAgentVersion.map(value => value),
        accessEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: String
    def arn: Option[Arn]
    def imageArn: Option[Arn]
    def description: Option[String]
    def displayName: Option[String]
    def vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly]
    def instanceType: Option[String]
    def platform: Option[zio.aws.appstream.model.PlatformType]
    def iamRoleArn: Option[Arn]
    def state: Option[zio.aws.appstream.model.ImageBuilderState]
    def stateChangeReason
        : Option[zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly]
    def createdTime: Option[Timestamp]
    def enableDefaultInternetAccess: Option[BooleanObject]
    def domainJoinInfo: Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly]
    def networkAccessConfiguration
        : Option[zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly]
    def imageBuilderErrors
        : Option[List[zio.aws.appstream.model.ResourceError.ReadOnly]]
    def appstreamAgentVersion: Option[AppstreamAgentVersion]
    def accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.appstream.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getIamRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getState
        : ZIO[Any, AwsError, zio.aws.appstream.model.ImageBuilderState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEnableDefaultInternetAccess: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "enableDefaultInternetAccess",
        enableDefaultInternetAccess
      )
    def getDomainJoinInfo
        : ZIO[Any, AwsError, zio.aws.appstream.model.DomainJoinInfo.ReadOnly] =
      AwsError.unwrapOptionField("domainJoinInfo", domainJoinInfo)
    def getNetworkAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkAccessConfiguration",
      networkAccessConfiguration
    )
    def getImageBuilderErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ResourceError.ReadOnly
    ]] = AwsError.unwrapOptionField("imageBuilderErrors", imageBuilderErrors)
    def getAppstreamAgentVersion: ZIO[Any, AwsError, AppstreamAgentVersion] =
      AwsError.unwrapOptionField("appstreamAgentVersion", appstreamAgentVersion)
    def getAccessEndpoints: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.AccessEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("accessEndpoints", accessEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.ImageBuilder
  ) extends zio.aws.appstream.model.ImageBuilder.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val imageArn: Option[Arn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val displayName: Option[String] =
      scala.Option(impl.displayName()).map(value => value: String)
    override val vpcConfig: Option[zio.aws.appstream.model.VpcConfig.ReadOnly] =
      scala
        .Option(impl.vpcConfig())
        .map(value => zio.aws.appstream.model.VpcConfig.wrap(value))
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val platform: Option[zio.aws.appstream.model.PlatformType] = scala
      .Option(impl.platform())
      .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val iamRoleArn: Option[Arn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val state: Option[zio.aws.appstream.model.ImageBuilderState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.appstream.model.ImageBuilderState.wrap(value))
    override val stateChangeReason: Option[
      zio.aws.appstream.model.ImageBuilderStateChangeReason.ReadOnly
    ] = scala
      .Option(impl.stateChangeReason())
      .map(value =>
        zio.aws.appstream.model.ImageBuilderStateChangeReason.wrap(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val enableDefaultInternetAccess: Option[BooleanObject] = scala
      .Option(impl.enableDefaultInternetAccess())
      .map(value => value: BooleanObject)
    override val domainJoinInfo
        : Option[zio.aws.appstream.model.DomainJoinInfo.ReadOnly] = scala
      .Option(impl.domainJoinInfo())
      .map(value => zio.aws.appstream.model.DomainJoinInfo.wrap(value))
    override val networkAccessConfiguration
        : Option[zio.aws.appstream.model.NetworkAccessConfiguration.ReadOnly] =
      scala
        .Option(impl.networkAccessConfiguration())
        .map(value =>
          zio.aws.appstream.model.NetworkAccessConfiguration.wrap(value)
        )
    override val imageBuilderErrors
        : Option[List[zio.aws.appstream.model.ResourceError.ReadOnly]] = scala
      .Option(impl.imageBuilderErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.ResourceError.wrap(item)
        }.toList
      )
    override val appstreamAgentVersion: Option[AppstreamAgentVersion] = scala
      .Option(impl.appstreamAgentVersion())
      .map(value =>
        zio.aws.appstream.model.primitives.AppstreamAgentVersion(value)
      )
    override val accessEndpoints
        : Option[List[zio.aws.appstream.model.AccessEndpoint.ReadOnly]] = scala
      .Option(impl.accessEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.AccessEndpoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.ImageBuilder
  ): zio.aws.appstream.model.ImageBuilder.ReadOnly = new Wrapper(impl)
}
