package zio.aws.appstream.model
import zio.ZIO
import zio.aws.appstream.model.primitives.{
  AppstreamAgentVersion,
  Timestamp,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Image(
    name: String,
    arn: Option[Arn] = None,
    baseImageArn: Option[Arn] = None,
    displayName: Option[String] = None,
    state: Option[zio.aws.appstream.model.ImageState] = None,
    visibility: Option[zio.aws.appstream.model.VisibilityType] = None,
    imageBuilderSupported: Option[Boolean] = None,
    imageBuilderName: Option[String] = None,
    platform: Option[zio.aws.appstream.model.PlatformType] = None,
    description: Option[String] = None,
    stateChangeReason: Option[zio.aws.appstream.model.ImageStateChangeReason] =
      None,
    applications: Option[Iterable[zio.aws.appstream.model.Application]] = None,
    createdTime: Option[Timestamp] = None,
    publicBaseImageReleasedDate: Option[Timestamp] = None,
    appstreamAgentVersion: Option[AppstreamAgentVersion] = None,
    imagePermissions: Option[zio.aws.appstream.model.ImagePermissions] = None,
    imageErrors: Option[Iterable[zio.aws.appstream.model.ResourceError]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.appstream.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.Image
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        baseImageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.baseImageArn)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(
        imageBuilderSupported.map(value => value: java.lang.Boolean)
      )(_.imageBuilderSupported)
      .optionallyWith(imageBuilderName.map(value => value: java.lang.String))(
        _.imageBuilderName
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(stateChangeReason.map(value => value.buildAwsValue()))(
        _.stateChangeReason
      )
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        publicBaseImageReleasedDate.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.publicBaseImageReleasedDate)
      .optionallyWith(
        appstreamAgentVersion.map(value =>
          AppstreamAgentVersion.unwrap(value): java.lang.String
        )
      )(_.appstreamAgentVersion)
      .optionallyWith(imagePermissions.map(value => value.buildAwsValue()))(
        _.imagePermissions
      )
      .optionallyWith(
        imageErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageErrors)
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.Image.ReadOnly =
    zio.aws.appstream.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appstream.model.Image] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.Image =
      zio.aws.appstream.model.Image(
        name,
        arn.map(value => value),
        baseImageArn.map(value => value),
        displayName.map(value => value),
        state.map(value => value),
        visibility.map(value => value),
        imageBuilderSupported.map(value => value),
        imageBuilderName.map(value => value),
        platform.map(value => value),
        description.map(value => value),
        stateChangeReason.map(value => value.asEditable),
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTime.map(value => value),
        publicBaseImageReleasedDate.map(value => value),
        appstreamAgentVersion.map(value => value),
        imagePermissions.map(value => value.asEditable),
        imageErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: String
    def arn: Option[Arn]
    def baseImageArn: Option[Arn]
    def displayName: Option[String]
    def state: Option[zio.aws.appstream.model.ImageState]
    def visibility: Option[zio.aws.appstream.model.VisibilityType]
    def imageBuilderSupported: Option[Boolean]
    def imageBuilderName: Option[String]
    def platform: Option[zio.aws.appstream.model.PlatformType]
    def description: Option[String]
    def stateChangeReason
        : Option[zio.aws.appstream.model.ImageStateChangeReason.ReadOnly]
    def applications: Option[List[zio.aws.appstream.model.Application.ReadOnly]]
    def createdTime: Option[Timestamp]
    def publicBaseImageReleasedDate: Option[Timestamp]
    def appstreamAgentVersion: Option[AppstreamAgentVersion]
    def imagePermissions
        : Option[zio.aws.appstream.model.ImagePermissions.ReadOnly]
    def imageErrors
        : Option[List[zio.aws.appstream.model.ResourceError.ReadOnly]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getBaseImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("baseImageArn", baseImageArn)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getState: ZIO[Any, AwsError, zio.aws.appstream.model.ImageState] =
      AwsError.unwrapOptionField("state", state)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.appstream.model.VisibilityType] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getImageBuilderSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("imageBuilderSupported", imageBuilderSupported)
    def getImageBuilderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageBuilderName", imageBuilderName)
    def getPlatform: ZIO[Any, AwsError, zio.aws.appstream.model.PlatformType] =
      AwsError.unwrapOptionField("platform", platform)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStateChangeReason: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ImageStateChangeReason.ReadOnly
    ] = AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.Application.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getPublicBaseImageReleasedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "publicBaseImageReleasedDate",
        publicBaseImageReleasedDate
      )
    def getAppstreamAgentVersion: ZIO[Any, AwsError, AppstreamAgentVersion] =
      AwsError.unwrapOptionField("appstreamAgentVersion", appstreamAgentVersion)
    def getImagePermissions: ZIO[
      Any,
      AwsError,
      zio.aws.appstream.model.ImagePermissions.ReadOnly
    ] = AwsError.unwrapOptionField("imagePermissions", imagePermissions)
    def getImageErrors: ZIO[Any, AwsError, List[
      zio.aws.appstream.model.ResourceError.ReadOnly
    ]] = AwsError.unwrapOptionField("imageErrors", imageErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.Image
  ) extends zio.aws.appstream.model.Image.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val baseImageArn: Option[Arn] = scala
      .Option(impl.baseImageArn())
      .map(value => zio.aws.appstream.model.primitives.Arn(value))
    override val displayName: Option[String] =
      scala.Option(impl.displayName()).map(value => value: String)
    override val state: Option[zio.aws.appstream.model.ImageState] = scala
      .Option(impl.state())
      .map(value => zio.aws.appstream.model.ImageState.wrap(value))
    override val visibility: Option[zio.aws.appstream.model.VisibilityType] =
      scala
        .Option(impl.visibility())
        .map(value => zio.aws.appstream.model.VisibilityType.wrap(value))
    override val imageBuilderSupported: Option[Boolean] =
      scala.Option(impl.imageBuilderSupported()).map(value => value: Boolean)
    override val imageBuilderName: Option[String] =
      scala.Option(impl.imageBuilderName()).map(value => value: String)
    override val platform: Option[zio.aws.appstream.model.PlatformType] = scala
      .Option(impl.platform())
      .map(value => zio.aws.appstream.model.PlatformType.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val stateChangeReason
        : Option[zio.aws.appstream.model.ImageStateChangeReason.ReadOnly] =
      scala
        .Option(impl.stateChangeReason())
        .map(value =>
          zio.aws.appstream.model.ImageStateChangeReason.wrap(value)
        )
    override val applications
        : Option[List[zio.aws.appstream.model.Application.ReadOnly]] = scala
      .Option(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.Application.wrap(item)
        }.toList
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val publicBaseImageReleasedDate: Option[Timestamp] = scala
      .Option(impl.publicBaseImageReleasedDate())
      .map(value => zio.aws.appstream.model.primitives.Timestamp(value))
    override val appstreamAgentVersion: Option[AppstreamAgentVersion] = scala
      .Option(impl.appstreamAgentVersion())
      .map(value =>
        zio.aws.appstream.model.primitives.AppstreamAgentVersion(value)
      )
    override val imagePermissions
        : Option[zio.aws.appstream.model.ImagePermissions.ReadOnly] = scala
      .Option(impl.imagePermissions())
      .map(value => zio.aws.appstream.model.ImagePermissions.wrap(value))
    override val imageErrors
        : Option[List[zio.aws.appstream.model.ResourceError.ReadOnly]] = scala
      .Option(impl.imageErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appstream.model.ResourceError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.Image
  ): zio.aws.appstream.model.Image.ReadOnly = new Wrapper(impl)
}
