package zio.aws.appstream.model
import scala.jdk.CollectionConverters._
sealed trait FleetType {
  def unwrap: software.amazon.awssdk.services.appstream.model.FleetType
}
object FleetType {
  def wrap(
      value: software.amazon.awssdk.services.appstream.model.FleetType
  ): zio.aws.appstream.model.FleetType = value match {
    case software.amazon.awssdk.services.appstream.model.FleetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appstream.model.FleetType.ALWAYS_ON =>
      val r = ALWAYS_ON
      r
    case software.amazon.awssdk.services.appstream.model.FleetType.ON_DEMAND =>
      val r = ON_DEMAND
      r
    case software.amazon.awssdk.services.appstream.model.FleetType.ELASTIC =>
      val r = ELASTIC
      r
  }
  case object unknownToSdkVersion extends zio.aws.appstream.model.FleetType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetType =
      software.amazon.awssdk.services.appstream.model.FleetType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALWAYS_ON extends zio.aws.appstream.model.FleetType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetType =
      software.amazon.awssdk.services.appstream.model.FleetType.ALWAYS_ON
  }
  case object ON_DEMAND extends zio.aws.appstream.model.FleetType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetType =
      software.amazon.awssdk.services.appstream.model.FleetType.ON_DEMAND
  }
  case object ELASTIC extends zio.aws.appstream.model.FleetType {
    override def unwrap
        : software.amazon.awssdk.services.appstream.model.FleetType =
      software.amazon.awssdk.services.appstream.model.FleetType.ELASTIC
  }
}
