package zio.aws.appstream.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FleetError(
    errorCode: Option[zio.aws.appstream.model.FleetErrorCode] = None,
    errorMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appstream.model.FleetError = {
    import FleetError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appstream.model.FleetError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.appstream.model.FleetError.ReadOnly =
    zio.aws.appstream.model.FleetError.wrap(buildAwsValue())
}
object FleetError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appstream.model.FleetError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appstream.model.FleetError =
      zio.aws.appstream.model.FleetError(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Option[zio.aws.appstream.model.FleetErrorCode]
    def errorMessage: Option[String]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.appstream.model.FleetErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appstream.model.FleetError
  ) extends zio.aws.appstream.model.FleetError.ReadOnly {
    override val errorCode: Option[zio.aws.appstream.model.FleetErrorCode] =
      scala
        .Option(impl.errorCode())
        .map(value => zio.aws.appstream.model.FleetErrorCode.wrap(value))
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appstream.model.FleetError
  ): zio.aws.appstream.model.FleetError.ReadOnly = new Wrapper(impl)
}
